/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class FileChooserViewer
extends ComponentViewer
implements ActionListener {
    static final long serialVersionUID = 20080517L;
    private JFileChooser chooser = new JFileChooser();
    private JTextField textField = new JTextField(30);
    private File selectedFile = null;
    private boolean openFile = true;
    private JButton button = new JButton("Browse");
    private String defaultDir = ".";

    public FileChooserViewer(Viewer superView) {
        this.setFileSelectionMode(2);
        this.setSuperView(superView);
        this.setContent(this.selectedFile, true);
        this.button.addActionListener(this);
        this.componentFor(null);
    }

    public void setFileSelectionMode(int mode) {
        this.chooser.setFileSelectionMode(mode);
    }

    public void setFile(File f) {
        this.selectedFile = f;
        this.textField.setText(this.selectedFile.getAbsolutePath());
        this.sendSignal(3, this.selectedFile);
        this.componentFor(null);
    }

    public JComponent componentFor(Object o) {
        this.removeAll();
        this.log.debug("build panel");
        this.setLayout(new GridLayout(0, 2));
        this.add(this.textField);
        this.textField.setEditable(false);
        this.add(this.button);
        this.setVisible(true);
        return this;
    }

    public void addActionListener(ActionListener l) {
        this.button.addActionListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        if (this.selectedFile != null) {
            this.chooser.setSelectedFile(this.selectedFile);
        } else {
            this.chooser.setSelectedFile(new File(this.defaultDir));
        }
        int n = returnVal = this.openFile ? this.chooser.showOpenDialog(null) : this.chooser.showSaveDialog(null);
        if (returnVal == 0) {
            this.setFile(this.chooser.getSelectedFile());
        }
    }

    public boolean canReceive(Object obj) {
        return false;
    }

    public void receiveContent(Object content) {
    }

    public String getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(String defaultDir) {
        if (defaultDir != null) {
            this.defaultDir = defaultDir;
        }
    }
}

