/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.text.learn.ClassifierAnnotator;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;

public class TrainClassifier
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.ClassificationSignalParams signal = new CommandLineUtil.ClassificationSignalParams(this.base);
    private CommandLineUtil.TrainClassifierParams train = new CommandLineUtil.TrainClassifierParams();
    private Classifier classifier = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.ClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ClassificationSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TrainClassifierParams getAdditionalParameters() {
        return this.train;
    }

    public void setAdditionalParameters(CommandLineUtil.TrainClassifierParams p) {
        this.train = p;
    }

    public String getTrainClassifierHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TrainClassifier%20Tutorial.htm\">TrainClassifier Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train});
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.spanProp == null && this.signal.spanType == null) {
            throw new IllegalArgumentException("one of -spanProp or -spanType must be specified");
        }
        if (this.signal.spanProp != null && this.signal.spanType != null) {
            throw new IllegalArgumentException("only one of -spanProp or -spanType can be specified");
        }
        Dataset d = CommandLineUtil.toDataset(this.base.labels, this.train.fe, this.signal.spanProp, this.signal.spanType, this.signal.candidateType);
        if (this.train.showData) {
            System.out.println("Trying to show the Dataset");
            new ViewerFrame("Dataset", d.toGUI());
        }
        this.classifier = new DatasetClassifierTeacher(d).train(this.train.learner);
        if (this.base.showResult) {
            SmartVanillaViewer cv = new SmartVanillaViewer();
            cv.setContent(this.classifier);
            new ViewerFrame("Classifier", cv);
        }
        String type = this.signal.getOutputType(this.train.output);
        String prop = this.signal.getOutputProp(this.train.output);
        ClassifierAnnotator ann = new ClassifierAnnotator(this.train.fe, this.classifier, type, prop, this.signal.candidateType);
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(ann, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    public Object getMainResult() {
        return this.classifier;
    }

    public static void main(String[] args) {
        new TrainClassifier().callMain(args);
    }
}

