/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiDatasetClassifierTeacher;
import edu.cmu.minorthird.classify.transform.PredictedClassTransform;
import edu.cmu.minorthird.classify.transform.TransformingMultiClassifier;
import edu.cmu.minorthird.text.learn.MultiClassifierAnnotator;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;

public class TrainMultiClassifier
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.MultiClassificationSignalParams signal = new CommandLineUtil.MultiClassificationSignalParams(this.base);
    private CommandLineUtil.TrainClassifierParams train = new CommandLineUtil.TrainClassifierParams();
    private MultiClassifier classifier = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.MultiClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.MultiClassificationSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TrainClassifierParams getAdditionalParameters() {
        return this.train;
    }

    public void setAdditionalParameters(CommandLineUtil.TrainClassifierParams p) {
        this.train = p;
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train});
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.multiSpanProp == null) {
            throw new IllegalArgumentException("-multiSpanProp  must be specified");
        }
        MultiDataset d = CommandLineUtil.toMultiDataset(this.base.labels, this.train.fe, this.signal.multiSpanProp);
        if (this.signal.cross) {
            d = d.annotateData();
        }
        if (this.train.showData) {
            System.out.println("Trying to show the Dataset");
            new ViewerFrame("Dataset", d.toGUI());
        }
        this.classifier = new MultiDatasetClassifierTeacher(d).train(this.train.learner);
        if (this.signal.cross) {
            PredictedClassTransform transformer = new PredictedClassTransform(this.classifier);
            this.classifier = new TransformingMultiClassifier(this.classifier, transformer);
        }
        if (this.base.showResult) {
            SmartVanillaViewer cv = new SmartVanillaViewer();
            if (this.classifier instanceof TransformingMultiClassifier) {
                cv.setContent((TransformingMultiClassifier)this.classifier);
            } else {
                cv.setContent(this.classifier);
            }
            new ViewerFrame("Classifier", cv);
        }
        MultiClassifierAnnotator ann = new MultiClassifierAnnotator(this.train.fe, this.classifier, this.signal.multiSpanProp);
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(ann, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    public Object getMainResult() {
        return this.classifier;
    }

    public static void main(String[] args) {
        new TrainMultiClassifier().callMain(args);
    }
}

