/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValidatedDataset;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TrainTestClassifier
extends UIMain {
    protected static Logger log = Logger.getLogger(TrainTestClassifier.class);
    protected CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    protected CommandLineUtil.ClassificationSignalParams signal = new CommandLineUtil.ClassificationSignalParams(this.base);
    protected CommandLineUtil.TrainClassifierParams train = new CommandLineUtil.TrainClassifierParams();
    protected CommandLineUtil.SplitterParams trainTest = new CommandLineUtil.SplitterParams();
    protected Object result = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams save) {
        this.save = save;
    }

    public CommandLineUtil.ClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ClassificationSignalParams signal) {
        this.signal = signal;
    }

    public CommandLineUtil.TrainClassifierParams getTrainingParameters() {
        return this.train;
    }

    public void setTrainingParameters(CommandLineUtil.TrainClassifierParams train) {
        this.train = train;
    }

    public CommandLineUtil.SplitterParams getSplitterParameters() {
        return this.trainTest;
    }

    public void setSplitterParameters(CommandLineUtil.SplitterParams trainTest) {
        this.trainTest = trainTest;
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train, this.trainTest});
    }

    public String getTrainTestClassifierHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TrainTestClassifier%20Tutorial.htm\">TrainTestClassifier Tutorial</A></html>";
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.spanProp == null && this.signal.spanType == null) {
            throw new IllegalArgumentException("one of -spanProp or -spanType must be specified");
        }
        if (this.signal.spanProp != null && this.signal.spanType != null) {
            throw new IllegalArgumentException("only one of -spanProp or -spanType can be specified");
        }
        Dataset d = CommandLineUtil.toDataset(this.base.labels, this.train.fe, this.signal.spanProp, this.signal.spanType, this.signal.candidateType);
        if (this.train.showData) {
            new ViewerFrame("Dataset", d.toGUI());
        }
        if (this.trainTest.labels != null) {
            if (this.signal.spanPropString != null) {
                CommandLineUtil.createSpanProp(this.signal.spanPropString, this.trainTest.labels);
            }
            Dataset testData = CommandLineUtil.toDataset(this.trainTest.labels, this.train.fe, this.signal.spanProp, this.signal.spanType, this.signal.candidateType);
            this.trainTest.splitter = new FixedTestSetSplitter<Example>(testData.iterator());
        }
        CrossValidatedDataset cvd = null;
        Evaluation evaluation = null;
        if (this.trainTest.showTestDetails) {
            cvd = new CrossValidatedDataset(this.train.learner, d, this.trainTest.splitter);
            evaluation = cvd.getEvaluation();
            this.result = cvd;
        } else {
            cvd = null;
            evaluation = Tester.evaluate(this.train.learner, d, (Splitter<Example>)this.trainTest.splitter);
            this.result = evaluation;
        }
        if (this.base.showResult) {
            new ViewerFrame("Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(evaluation, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
        evaluation.summarize();
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TrainTestClassifier().callMain(args);
    }
}

