/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import edu.cmu.minorthird.util.Saveable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IOUtil {
    public static boolean saveSomehow(Object obj, File file) {
        return IOUtil.saveSomehow(obj, file, false);
    }

    public static boolean saveSomehow(Object obj, File file, boolean complainAboutProblems) {
        try {
            if (obj instanceof Saveable) {
                Saveable saveObj = (Saveable)obj;
                String defaultFormat = saveObj.getFormatNames()[0];
                saveObj.saveAs(file, defaultFormat);
                return true;
            }
            if (obj instanceof Serializable) {
                IOUtil.saveSerialized((Serializable)obj, file);
                return true;
            }
            if (complainAboutProblems) {
                System.out.println("don't know how to save object of type " + obj.getClass());
            }
            return false;
        }
        catch (IOException ex) {
            if (complainAboutProblems) {
                System.out.println("exception saving object of type " + obj.getClass());
                ex.printStackTrace();
            }
            return false;
        }
    }

    public static void saveSerialized(Serializable obj, File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeObject(obj);
        out.close();
    }

    public static Serializable loadSerialized(File file) throws IOException {
        try {
            return IOUtil.loadSerialized(new FileInputStream(file));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("can't read serialized object from " + file + ": " + e);
        }
    }

    public static Serializable loadSerialized(InputStream input) throws IOException {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(input));
            Object obj = in.readObject();
            in.close();
            return (Serializable)obj;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("can't read serialized object from " + input + ": " + e);
        }
    }

    public static String readFile(File in) throws IOException {
        String line = null;
        StringBuffer content = new StringBuffer("");
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(in));
            while ((line = bReader.readLine()) != null) {
                content.append(line + "\n");
            }
            bReader.close();
        }
        catch (IOException ioe) {
            System.err.println("Error reading " + in + ": " + ioe);
        }
        return content.toString();
    }
}

