/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.Version;
import org.apache.log4j.Logger;

public class JointCommandLineProcessor
implements CommandLineProcessor {
    private static Logger log = Logger.getLogger(JointCommandLineProcessor.class);
    private boolean helpConsumed;
    private CommandLineProcessor[] subprocessor;

    public JointCommandLineProcessor(CommandLineProcessor[] subprocessor) {
        this.subprocessor = subprocessor;
        this.helpConsumed = false;
    }

    public boolean shouldTerminate() {
        return this.helpConsumed;
    }

    public final void processArguments(String[] args) {
        System.out.println("*** Minorthird: " + Version.getVersion() + " ***");
        int k = 0;
        while (k < args.length) {
            int delta = this.consumeArguments(args, k);
            k += delta;
            if (delta != 0) continue;
            ++delta;
            if (k + 1 < args.length && !args[k + 1].startsWith("-")) {
                ++delta;
                log.warn("Unknown arguments " + args[k] + " " + args[k + 1] + " will be ignored");
            } else {
                log.warn("Unknown argument " + args[k] + " will be ignored");
            }
            k += delta;
        }
    }

    public final int consumeArguments(String[] args, int startPos) {
        int pos = startPos;
        boolean somethingConsumed = true;
        while (pos < args.length && somethingConsumed) {
            if ("-help".equals(args[pos]) || "--help".equals(args[pos])) {
                this.helpConsumed = true;
                this.help();
                ++pos;
                continue;
            }
            if ("-config".equals(args[pos]) || "--config".equals(args[pos])) {
                if (pos + 1 < args.length) {
                    BasicCommandLineProcessor.config(args[pos + 1], this);
                    pos += 2;
                    continue;
                }
                this.usage("missing argument for -config");
                continue;
            }
            somethingConsumed = false;
            for (int i = 0; !somethingConsumed && i < this.subprocessor.length; ++i) {
                int k = this.subprocessor[i].consumeArguments(args, pos);
                if (k <= 0) continue;
                log.info("subprocessor" + i + " consumed " + k + " args at pos=" + pos);
                pos += k;
                somethingConsumed = true;
            }
        }
        return pos - startPos;
    }

    public final void usage(String errorMessage) {
        System.out.println(errorMessage);
        this.usage();
    }

    public final void usage() {
        for (int i = 0; i < this.subprocessor.length; ++i) {
            log.info("subprocessor" + i + " usage invoked");
            this.subprocessor[i].usage();
        }
    }

    public final void help() {
        this.usage();
    }
}

