/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.gui.Viewer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelViewer
extends Viewer {
    static final long serialVersionUID = 20080517L;
    private JTabbedPane parallelPane;
    private List<Viewer> subViewList;

    @Override
    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.parallelPane = new JTabbedPane();
        this.subViewList = new ArrayList<Viewer>();
        this.add((Component)this.parallelPane, ParallelViewer.fillerGBC());
        this.parallelPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ParallelViewer.this.receiveContent(ParallelViewer.this.getContent());
            }
        });
    }

    public void putTabsOnLeft() {
        this.parallelPane.setTabPlacement(2);
        this.parallelPane.setTabLayoutPolicy(1);
    }

    public void addSubView(String title, Viewer view) {
        view.setSuperView(this, title);
        this.subViewList.add(view);
        this.parallelPane.add(title, view);
    }

    @Override
    public void receiveContent(Object content) {
        Viewer subView = this.subViewList.get(this.parallelPane.getSelectedIndex());
        subView.setContent(content);
    }

    @Override
    public Viewer getNamedSubView(String name) {
        Viewer subviewer = super.getNamedSubView(name);
        subviewer.setContent(this.getContent());
        return subviewer;
    }

    @Override
    public boolean canReceive(Object content) {
        for (Viewer subView : this.subViewList) {
            if (subView.canReceive(content)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearContent() {
        for (Viewer subView : this.subViewList) {
            subView.clearContent();
        }
    }

    @Override
    protected void handle(int signal, Object argument, List<Viewer> senders) {
        throw new IllegalStateException("signal:" + signal + " argument:" + argument + " at:" + this);
    }

    @Override
    protected boolean canHandle(int signal, Object argument, List<Viewer> senders) {
        return false;
    }
}

