/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Viewer
extends JPanel {
    private static Logger log = Logger.getLogger(Viewer.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final String ONLY_SUBVIEWER = "*main*";
    protected static final int SET_CONTENT = 1;
    protected static final int TEXT_MESSAGE = 2;
    protected static final int OBJECT_SELECTED = 3;
    protected static final int OBJECT_UPDATED = 4;
    private Viewer superView = null;
    private Object content = "empty view";
    protected Map<String, Viewer> namedSubViews = new TreeMap<String, Viewer>();
    private final Transform IDENTITY_TRANSFORM = new Transform(){

        public Object transform(Object o) {
            return o;
        }
    };

    public Viewer() {
        this((Object)null);
    }

    public Viewer(Object content) {
        this.initialize();
        if (content != null) {
            this.setContent(content);
        }
    }

    public final void setSuperView(Viewer superView) {
        this.setSuperView(superView, ONLY_SUBVIEWER);
    }

    public final void setSuperView(Viewer superView, String title) {
        this.superView = superView;
        superView.namedSubViews.put(title, this);
    }

    public final Viewer getSuperView() {
        return this.superView;
    }

    public final void setContent(Object content) {
        this.setContent(content, false);
    }

    public final void setContent(Object content, boolean forceUpdate) {
        if (content != this.content || forceUpdate) {
            this.content = content;
            this.receiveContent(content);
            this.sendSignal(1, content);
        }
    }

    public final Object getContent() {
        return this.content;
    }

    public Object getVisibleContent() {
        if (this.namedSubViews.size() == 1 && this.namedSubViews.get(ONLY_SUBVIEWER) != null) {
            Object result = this.namedSubViews.get(ONLY_SUBVIEWER).getVisibleContent();
            return result;
        }
        return this.content;
    }

    public Object getSerializableContent() {
        if (!(this.content instanceof Serializable) && this.namedSubViews.get(ONLY_SUBVIEWER) != null) {
            Object result = this.namedSubViews.get(ONLY_SUBVIEWER).getSerializableContent();
            return result;
        }
        return this.content;
    }

    protected final void sendSignal(int signal, Object argument) {
        if (DEBUG) {
            log.debug("signal sent by " + this + ": " + signal + "," + argument);
        }
        if (this.superView != null) {
            ArrayList<Viewer> senders = new ArrayList<Viewer>();
            senders.add(this);
            this.superView.hearBroadcast(signal, argument, senders);
        }
    }

    private final void hearBroadcast(int signal, Object argument, List<Viewer> senders) {
        if (this.canHandle(signal, argument, senders)) {
            if (DEBUG) {
                log.debug("signal claimed by " + this + ": " + signal + "," + argument + "," + senders);
            }
            this.handle(signal, argument, senders);
        } else if (this.superView != null) {
            if (DEBUG) {
                log.debug("signal forwarded to " + this.superView + ": " + signal + "," + argument + "," + senders);
            }
            senders.add(this);
            this.superView.hearBroadcast(signal, argument, senders);
        } else if (this.superView == null && DEBUG) {
            log.debug("no superview set for " + this);
        }
    }

    protected abstract void initialize();

    public abstract void receiveContent(Object var1);

    public abstract void clearContent();

    public abstract boolean canReceive(Object var1);

    protected abstract void handle(int var1, Object var2, List<Viewer> var3);

    protected abstract boolean canHandle(int var1, Object var2, List<Viewer> var3);

    public Set<String> getSubViewNames() {
        Viewer onlySubviewer = this.namedSubViews.get(ONLY_SUBVIEWER);
        if (onlySubviewer != null) {
            return onlySubviewer.getSubViewNames();
        }
        return this.namedSubViews.keySet();
    }

    public Viewer getNamedSubView(String name) {
        Viewer onlySubviewer = this.namedSubViews.get(ONLY_SUBVIEWER);
        if (onlySubviewer != null) {
            return onlySubviewer.getNamedSubView(name);
        }
        return this.namedSubViews.get(name);
    }

    protected static GridBagConstraints fillerGBC() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        return gbc;
    }

    protected void monitorSelections(final JList jlist, final Transform transformer) {
        jlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = jlist.locationToIndex(e.getPoint());
                Viewer.this.sendSignal(3, transformer.transform(jlist.getModel().getElementAt(index)));
            }
        });
    }

    protected void monitorSelections(JList jlist) {
        this.monitorSelections(jlist, this.IDENTITY_TRANSFORM);
    }

    protected void monitorSelections(final JTable jtable, final int colIndex, final Transform transformer) {
        jtable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int rowIndex = jtable.rowAtPoint(e.getPoint());
                Viewer.this.sendSignal(3, transformer.transform(jtable.getModel().getValueAt(rowIndex, colIndex)));
            }
        });
    }

    protected void monitorSelections(JTable jtable, int colIndex) {
        this.monitorSelections(jtable, colIndex, this.IDENTITY_TRANSFORM);
    }

    protected static interface Transform {
        public Object transform(Object var1);
    }
}

