/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;

public class CrfParams
implements Serializable {
    public double initValue = 0.0;
    public double invSigmaSquare = 0.01;
    public int maxIters = 100;
    public double epsForConvergence = 0.001;
    public int mForHessian = 7;
    public String trainerType = "";
    public String inferenceType = "Viterbi";
    public int beamSize = 1;
    public int debugLvl = 1;
    public boolean doScaling = true;
    public boolean doRobustScale = false;
    public boolean reuseM = false;
    public Properties miscOptions;

    public CrfParams() {
    }

    public CrfParams(String args) {
        this(CrfParams.stringToOptions(args));
    }

    static Properties stringToOptions(String args) {
        Properties opts = new Properties();
        StringTokenizer tok = new StringTokenizer(args, " ");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            String value = tok.nextToken();
            opts.put(name, value);
        }
        return opts;
    }

    public CrfParams(Properties opts) {
        this.parseParameters(opts);
    }

    public void parseParameters(Properties opts) {
        this.miscOptions = opts;
        if (opts.getProperty("initValue") != null) {
            this.initValue = Double.parseDouble(opts.getProperty("initValue"));
        }
        if (opts.getProperty("maxIters") != null) {
            this.maxIters = Integer.parseInt(opts.getProperty("maxIters"));
        }
        if (opts.getProperty("invSigmaSquare") != null) {
            this.invSigmaSquare = Double.parseDouble(opts.getProperty("invSigmaSquare"));
        }
        if (opts.getProperty("debugLvl") != null) {
            this.debugLvl = Integer.parseInt(opts.getProperty("debugLvl"));
        }
        if (opts.getProperty("scale") != null) {
            this.doScaling = opts.getProperty("scale").equalsIgnoreCase("true");
        }
        if (opts.getProperty("robustScale") != null) {
            this.doRobustScale = opts.getProperty("robustScale").equalsIgnoreCase("true");
        }
        if (opts.getProperty("epsForConvergence") != null) {
            this.epsForConvergence = Double.parseDouble(opts.getProperty("epsForConvergence"));
        }
        if (opts.getProperty("mForHessian") != null) {
            this.mForHessian = Integer.parseInt(opts.getProperty("mForHessian"));
        }
        if (opts.getProperty("trainer") != null) {
            this.trainerType = opts.getProperty("trainer");
        }
        if (opts.getProperty("inferenceType") != null) {
            this.inferenceType = opts.getProperty("inferenceType");
        }
        if (opts.getProperty("beamSize") != null) {
            try {
                this.beamSize = Integer.parseInt(opts.getProperty("beamSize"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.reuseM = Boolean.valueOf(opts.getProperty("reuseM", "false"));
    }
}

