/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import cern.colt.function.IntDoubleFunction;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import iitb.CRF.CRF;
import iitb.CRF.DataSequence;
import iitb.CRF.LogSparseDoubleMatrix1D;
import iitb.CRF.LogSparseDoubleMatrix2D;
import iitb.CRF.SparseTrainer;
import iitb.CRF.Viterbi;

public class SparseViterbi
extends Viterbi {
    protected Context[] context;
    protected LogSparseDoubleMatrix1D Ri;
    ObjectArrayList prevContext = new ObjectArrayList();
    IntArrayList validYs = new IntArrayList();
    IntArrayList validPrevYs = new IntArrayList();
    DoubleArrayList values = new DoubleArrayList();
    protected ContextUpdate contextUpdate;

    protected SparseViterbi(CRF model, int bs) {
        super(model, bs);
    }

    protected void computeLogMi(DataSequence dataSeq, int i, int ell, double[] lambda) {
        this.model.featureGenerator.startScanFeaturesAt(dataSeq, i);
        SparseTrainer.computeLogMi(this.model.featureGenerator, lambda, this.Mi, this.Ri);
    }

    protected Iter getIter() {
        return new Iter();
    }

    protected void finishContext(int i2) {
    }

    protected double getCorrectScore(DataSequence dataSeq, int i, int ell) {
        return this.Ri.getQuick(dataSeq.y(i)) + (i > 0 ? this.Mi.get(dataSeq.y(i - 1), dataSeq.y(i)) : 0.0);
    }

    protected ContextUpdate newContextUpdate() {
        return new ContextUpdate();
    }

    protected void allocateScratch(int numY) {
        this.Mi = new LogSparseDoubleMatrix2D(numY, numY);
        this.Ri = new LogSparseDoubleMatrix1D(numY);
        this.context = new Context[0];
        this.finalSoln = new Viterbi.Entry(this, this.beamsize, 0, 0);
        this.contextUpdate = this.newContextUpdate();
        this.contextUpdate.iter = this.getIter();
    }

    protected Context newContext(int numY, int beamsize, int pos) {
        return new Context(numY, beamsize, pos);
    }

    public double viterbiSearch(DataSequence dataSeq, double[] lambda, boolean calcCorrectScore) {
        if (this.Mi == null) {
            this.allocateScratch(this.model.numY);
        }
        if (this.context.length < dataSeq.length() + 1) {
            int l;
            Context[] oldContext = this.context;
            this.context = new Context[dataSeq.length() + 1];
            for (l = 0; l < oldContext.length; ++l) {
                this.context[l] = oldContext[l];
            }
            for (l = oldContext.length; l < this.context.length; ++l) {
                this.context[l] = this.newContext(this.model.numY, this.beamsize, l);
            }
        }
        double corrScore = this.contextUpdate.fillArray(dataSeq, lambda, calcCorrectScore);
        this.finalSoln.clear();
        this.finalSoln.valid = true;
        int i = dataSeq.length() - 1;
        if (i >= 0) {
            for (int y = 0; y < this.context[i].size(); ++y) {
                if (!this.context[i].entryNotNull(y)) continue;
                this.finalSoln.add((Viterbi.Entry)this.context[i].getQuick(y), 0.0f);
            }
        }
        if (this.model.params.debugLvl > 1) {
            System.out.println("Score of best sequence " + this.finalSoln.get((int)0).score + " corrScore " + corrScore);
        }
        return corrScore;
    }

    protected class ContextUpdate
    implements IntIntDoubleFunction,
    IntDoubleFunction {
        protected int i;
        protected int ell;
        protected Iter iter;

        protected ContextUpdate() {
        }

        public double apply(int yp, int yi, double val) {
            if (SparseViterbi.this.context[this.i - this.ell].entryNotNull(yp)) {
                SparseViterbi.this.context[this.i].add(yi, SparseViterbi.this.context[this.i - this.ell].getEntry(yp), (float)(SparseViterbi.this.Mi.get(yp, yi) + SparseViterbi.this.Ri.get(yi)));
            }
            return val;
        }

        public double apply(int yi, double val) {
            SparseViterbi.this.context[this.i].add(yi, null, (float)SparseViterbi.this.Ri.get(yi));
            return val;
        }

        double fillArray(DataSequence dataSeq, double[] lambda, boolean calcScore) {
            double corrScore = 0.0;
            this.i = 0;
            while (this.i < dataSeq.length()) {
                SparseViterbi.this.context[this.i].clear();
                this.iter.start(this.i, dataSeq);
                while ((this.ell = this.iter.nextEll(this.i)) > 0) {
                    SparseViterbi.this.computeLogMi(dataSeq, this.i, this.ell, lambda);
                    if (this.i - this.ell < 0) {
                        SparseViterbi.this.Ri.forEachNonZero(this);
                    } else {
                        SparseViterbi.this.Mi.forEachNonZero(this);
                    }
                    if (SparseViterbi.this.model.params.debugLvl > 1) {
                        System.out.println("Ri " + SparseViterbi.this.Ri);
                        System.out.println("Mi " + SparseViterbi.this.Mi);
                    }
                    if (!calcScore) continue;
                    corrScore += SparseViterbi.this.getCorrectScore(dataSeq, this.i, this.ell);
                }
                SparseViterbi.this.finishContext(this.i);
                ++this.i;
            }
            return corrScore;
        }
    }

    protected class Iter {
        protected int ell;

        protected Iter() {
        }

        protected void start(int i, DataSequence dataSeq) {
            this.ell = 1;
        }

        protected int nextEll(int i) {
            return this.ell--;
        }
    }

    protected class Context
    extends DenseObjectMatrix1D {
        protected int pos;
        protected int beamsize;

        protected Context(int numY, int beamsize, int pos) {
            super(numY);
            this.pos = pos;
            this.beamsize = beamsize;
        }

        protected Viterbi.Entry newEntry(int beamsize, int label, int pos) {
            return new Viterbi.Entry(SparseViterbi.this, beamsize, label, pos);
        }

        public void add(int y, Viterbi.Entry prevEntry, float thisScore) {
            if (this.getQuick(y) == null) {
                this.setQuick(y, this.newEntry(this.pos == 0 ? 1 : this.beamsize, y, this.pos));
            }
            this.getEntry((int)y).valid = true;
            this.getEntry(y).add(prevEntry, thisScore);
        }

        public void clear() {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getQuick(i) == null) continue;
                this.getEntry(i).clear();
            }
        }

        public Viterbi.Entry getEntry(int y) {
            return (Viterbi.Entry)this.getQuick(y);
        }

        public boolean entryNotNull(int y) {
            return this.getQuick(y) != null && this.getEntry((int)y).valid;
        }

        void assign(LogSparseDoubleMatrix1D Ri) {
            for (int y = 0; y < Ri.size(); ++y) {
                if (Ri.getQuick(y) == 0.0) continue;
                this.add(y, null, (float)Ri.get(y));
            }
        }
    }
}

