/*
 * Decompiled with CFR 0.152.
 */
package iitb.MaxentClassifier;

import iitb.MaxentClassifier.DataDesc;
import iitb.MaxentClassifier.DataRecord;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class FileData {
    BufferedReader inpStream;
    DataDesc dataDescriptor;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileData() {
    }

    void openForRead(String fileName, DataDesc data) throws IOException {
        this.inpStream = new BufferedReader(new FileReader(fileName));
        this.dataDescriptor = data;
    }

    boolean readNext(DataRecord dataRecord) throws IOException {
        return FileData.readNext(this.inpStream, this.dataDescriptor, dataRecord);
    }

    static boolean readNext(BufferedReader in, DataDesc dataDesc, DataRecord dataRecord) throws IOException {
        String line = in.readLine();
        if (line != null) {
            StringTokenizer strTok = new StringTokenizer(line, dataDesc.colSep);
            for (int colNum = 0; strTok.hasMoreTokens() && colNum < dataDesc.numColumns; ++colNum) {
                dataRecord.vals[colNum] = (float)Double.parseDouble(strTok.nextToken());
            }
            if (!$assertionsDisabled && !strTok.hasMoreTokens()) {
                throw new AssertionError();
            }
            dataRecord.label = Integer.parseInt(strTok.nextToken());
            if (!($assertionsDisabled || dataRecord.label >= 0 && dataRecord.label < dataDesc.numLabels)) {
                throw new AssertionError();
            }
            return true;
        }
        return false;
    }

    static Vector read(String fileName, DataDesc dataDesc) throws IOException {
        Vector<DataRecord> allRecords = new Vector<DataRecord>();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        DataRecord dataRecord = new DataRecord(dataDesc.numColumns);
        while (FileData.readNext(in, dataDesc, dataRecord)) {
            allRecords.add(new DataRecord(dataRecord));
        }
        return allRecords;
    }

    static void write(String fileName, Vector allRecords, int numColumns, String colSep) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        Enumeration e = allRecords.elements();
        while (e.hasMoreElements()) {
            DataRecord dataRecord = (DataRecord)e.nextElement();
            for (int i = 0; i < numColumns; ++i) {
                out.print(dataRecord.getColumn(i) + colSep);
            }
            out.println(dataRecord.y(0));
        }
        out.close();
    }

    static {
        $assertionsDisabled = !FileData.class.desiredAssertionStatus();
    }
}

