/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;

public class EdgeLinearHistFeatures
extends FeatureTypes {
    Object[][] fnames;
    int histsize;
    boolean allDone;
    int[] histArr;
    int histPos;
    EdgeIterator edgeIter;
    Edge edge;
    int edgeNum;

    public EdgeLinearHistFeatures(FeatureGenImpl m, Object[][] labels, int histsize) {
        super(m);
        this.fnames = labels;
        this.edgeIter = this.model.edgeIterator();
        this.histsize = histsize;
        this.histArr = new int[histsize];
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.allDone = false;
        this.edgeIter.start();
        if (pos < 2 || !this.edgeIter.hasNext()) {
            this.allDone = true;
        }
        this.histPos = 1;
        this.edge = this.edgeIter.next();
        this.edgeNum = 0;
        return this.allDone;
    }

    public boolean hasNext() {
        return this.histsize > 1 && !this.allDone;
    }

    public void next(FeatureImpl f) {
        int i = 0;
        while (i < this.histArr.length) {
            this.histArr[i++] = -1;
        }
        this.histArr[this.histPos] = this.edge.start;
        f.yend = this.edge.end;
        f.historyArray = this.histArr;
        f.val = 1.0f;
        Object fname = this.fnames == null ? "H." + this.histPos : this.fnames[this.histPos][f.yend];
        ++this.histPos;
        if (this.histPos + 1 > this.histsize) {
            this.histPos = 1;
            if (this.edgeIter.hasNext()) {
                this.edge = this.edgeIter.next();
                ++this.edgeNum;
            } else {
                this.allDone = true;
            }
        }
        this.setFeatureIdentifier(this.edgeNum * this.histPos, this.model.label(f.yend), fname, f);
    }
}

