/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import gnu.trove.TIntHashSet;
import iitb.CRF.DataIter;
import iitb.CRF.DataSequence;
import iitb.CRF.Feature;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.SegmentDataSequence;
import iitb.Model.ConcatRegexFeatures;
import iitb.Model.EdgeFeatures;
import iitb.Model.EndFeatures;
import iitb.Model.FeatureIdentifier;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Model.FeatureTypesEachLabel;
import iitb.Model.Model;
import iitb.Model.StartFeatures;
import iitb.Model.UnknownFeature;
import iitb.Model.WordFeatures;
import iitb.Model.WordsInTrain;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class FeatureGenImpl
implements FeatureGeneratorNested {
    Vector features;
    transient Iterator featureIter;
    protected FeatureTypes currentFeatureType;
    protected FeatureImpl featureToReturn;
    protected FeatureImpl feature;
    public Model model;
    int numFeatureTypes = 0;
    int totalFeatures;
    boolean _fixedTransitions = true;
    public boolean generateOnlyXFeatures = false;
    public boolean addOnlyTrainFeatures = true;
    TIntHashSet retainedFeatureTypes = new TIntHashSet();
    transient DataSequence data;
    int cposEnd;
    int cposStart;
    WordsInTrain dict;
    boolean featureCollectMode = false;
    FeatureMap featureMap;

    public void addFeature(FeatureTypes fType) {
        this.addFeature(fType, false);
    }

    public void addFeature(FeatureTypes fType, boolean retainThis) {
        this.features.add(fType);
        if (retainThis) {
            this.retainedFeatureTypes.add(fType.getTypeId() + 1);
        }
        if (!fType.fixedTransitionFeatures()) {
            this._fixedTransitions = false;
        }
    }

    public void setDict(WordsInTrain d) {
        this.dict = d;
    }

    public WordsInTrain getDict() {
        if (this.dict == null) {
            this.dict = new WordsInTrain();
        }
        return this.dict;
    }

    protected void addFeatures() {
        this.addFeature(new EdgeFeatures(this));
        this.addFeature(new StartFeatures(this));
        this.addFeature(new EndFeatures(this));
        this.dict = new WordsInTrain();
        this.addFeature(new UnknownFeature(this, this.dict));
        this.addFeature(new WordFeatures(this, this.dict));
        this.addFeature(new FeatureTypesEachLabel(this, new ConcatRegexFeatures(this, 0, 0)));
    }

    protected FeatureTypes getFeature(int i) {
        return (FeatureTypes)this.features.elementAt(i);
    }

    protected boolean keepFeature(DataSequence seq, FeatureImpl f) {
        if (this.retainedFeatureTypes != null && this.retainedFeatureTypes.contains(this.currentFeatureType.getTypeId() + 1)) {
            return true;
        }
        return this.retainFeature(seq, f);
    }

    protected boolean retainFeature(DataSequence seq, FeatureImpl f) {
        return seq.y(this.cposEnd) == f.y() && (this.cposStart == 0 || f.yprev() < 0 || seq.y(this.cposStart - 1) == f.yprev());
    }

    static Model getModel(String modelSpecs, int numLabels) throws Exception {
        return Model.getNewModel(numLabels, modelSpecs);
    }

    public FeatureGenImpl(String modelSpecs, int numLabels) throws Exception {
        this(modelSpecs, numLabels, true);
    }

    public FeatureGenImpl(String modelSpecs, int numLabels, boolean addFeatureNow) throws Exception {
        this(FeatureGenImpl.getModel(modelSpecs, numLabels), numLabels, addFeatureNow);
    }

    public FeatureGenImpl(Model m, int numLabels, boolean addFeatureNow) throws Exception {
        this.model = m;
        this.features = new Vector();
        this.featureToReturn = new FeatureImpl();
        this.feature = new FeatureImpl();
        this.featureMap = new FeatureMap();
        if (addFeatureNow) {
            this.addFeatures();
        }
    }

    public boolean stateMappings(DataIter trainData) throws Exception {
        if (this.model.numStates() == this.model.numberOfLabels()) {
            return false;
        }
        trainData.startScan();
        while (trainData.hasNext()) {
            DataSequence seq = trainData.next();
            if (seq instanceof SegmentDataSequence) {
                this.model.stateMappings((SegmentDataSequence)seq);
                continue;
            }
            this.model.stateMappings(seq);
        }
        return true;
    }

    public boolean mapStatesToLabels(DataSequence data) {
        if (this.model.numStates() == this.model.numberOfLabels()) {
            return false;
        }
        if (data instanceof SegmentDataSequence) {
            this.model.mapStatesToLabels((SegmentDataSequence)data);
        } else {
            for (int i = 0; i < data.length(); ++i) {
                data.set_y(i, this.label(data.y(i)));
            }
        }
        return true;
    }

    public int maxMemory() {
        return 1;
    }

    public boolean train(DataIter trainData) throws Exception {
        return this.train(trainData, true);
    }

    public boolean train(DataIter trainData, boolean cachedLabels) throws Exception {
        return this.train(trainData, cachedLabels, true);
    }

    public boolean labelMappingNeeded() {
        return this.model.numStates() != this.model.numberOfLabels();
    }

    public boolean train(DataIter trainData, boolean cachedLabels, boolean collectIds) throws Exception {
        boolean labelsMapped = false;
        if (cachedLabels) {
            labelsMapped = this.stateMappings(trainData);
        }
        if (this.dict != null) {
            this.dict.train(trainData, this.model.numStates());
        }
        boolean requiresTraining = false;
        for (int f = 0; f < this.features.size(); ++f) {
            if (!this.getFeature(f).requiresTraining()) continue;
            requiresTraining = true;
            break;
        }
        if (requiresTraining) {
            trainData.startScan();
            while (trainData.hasNext()) {
                DataSequence seq = trainData.next();
                for (int l = 0; l < seq.length(); ++l) {
                    for (int f = 0; f < this.features.size(); ++f) {
                        this.getFeature(f).train(seq, l);
                    }
                }
            }
        }
        if (collectIds) {
            this.totalFeatures = this.featureMap.collectFeatureIdentifiers(trainData, this.maxMemory());
        }
        return labelsMapped;
    }

    public void addTrainRecord(DataSequence seq) {
        for (int l = 0; l < seq.length(); ++l) {
            this.startScanFeaturesAt(seq, l);
            while (this.hasNext()) {
                this.next();
            }
        }
    }

    public void printStats() {
        System.out.println("Num states " + this.model.numStates());
        System.out.println("Num edges " + this.model.numEdges());
        if (this.dict != null) {
            System.out.println("Num words in dictionary " + this.dict.dictionaryLength());
        }
        System.out.println("Num features " + this.numFeatures());
    }

    protected FeatureImpl nextNoId() {
        this.feature.copy(this.featureToReturn);
        this.advance(false);
        return this.feature;
    }

    protected void advance() {
        this.advance(!this.featureCollectMode);
    }

    /*
     * Unable to fully structure code
     */
    protected void advance(boolean returnWithId) {
        block3: {
            block0: while (true) {
                if ((this.currentFeatureType == null || !this.currentFeatureType.hasNext()) && this.featureIter.hasNext()) {
                    this.currentFeatureType = (FeatureTypes)this.featureIter.next();
                    continue;
                }
                if (!this.currentFeatureType.hasNext()) break block3;
                do {
                    if (this.currentFeatureType.hasNext()) ** break;
                    continue block0;
                    this.featureToReturn.init();
                    this.copyNextFeature(this.featureToReturn);
                    this.featureToReturn.id = this.featureMap.getId(this.featureToReturn);
                } while (this.featureToReturn.id < 0 || !FeatureGenImpl.featureValid(this.data, this.cposStart, this.cposEnd, this.featureToReturn, this.model));
                break;
            }
            return;
        }
        this.featureToReturn.id = -1;
    }

    protected void copyNextFeature(FeatureImpl featureToReturn) {
        this.currentFeatureType.next(featureToReturn);
    }

    public static boolean featureValid(DataSequence data, int cposStart, int cposEnd, FeatureImpl featureToReturn, Model model) {
        if (cposStart > 0 && cposEnd < data.length() - 1 || featureToReturn.y() >= model.numStates() || featureToReturn.yprev() >= model.numStates()) {
            return true;
        }
        if (cposStart == 0 && model.isStartState(featureToReturn.y()) && (data.length() > 1 || model.isEndState(featureToReturn.y()))) {
            return true;
        }
        return cposEnd == data.length() - 1 && model.isEndState(featureToReturn.y());
    }

    protected void initScanFeaturesAt(DataSequence d) {
        this.data = d;
        this.currentFeatureType = null;
        this.featureIter = this.features.iterator();
        this.advance();
    }

    public void startScanFeaturesAt(DataSequence d, int prev, int p) {
        this.cposEnd = p;
        this.cposStart = prev + 1;
        for (int i = 0; i < this.features.size(); ++i) {
            this.getFeature(i).startScanFeaturesAt(d, prev, this.cposEnd);
        }
        this.initScanFeaturesAt(d);
    }

    public void startScanFeaturesAt(DataSequence d, int p) {
        this.cposEnd = p;
        this.cposStart = p;
        for (int i = 0; i < this.features.size(); ++i) {
            this.getFeature(i).startScanFeaturesAt(d, this.cposEnd);
        }
        this.initScanFeaturesAt(d);
    }

    public boolean hasNext() {
        return this.featureToReturn.id >= 0;
    }

    public Feature next() {
        this.feature.copy(this.featureToReturn);
        this.advance();
        return this.feature;
    }

    public void freezeFeatures() {
        if (this.featureCollectMode) {
            this.featureMap.freezeFeatures();
        }
    }

    public int numFeatures() {
        return this.totalFeatures;
    }

    public FeatureIdentifier featureIdentifier(int id) {
        return this.featureMap.getIdentifier(id);
    }

    public String featureName(int featureIndex) {
        return this.featureMap.getName(featureIndex);
    }

    public int numStates() {
        return this.model.numStates();
    }

    public int label(int stateNum) {
        return this.model.label(stateNum);
    }

    protected int numFeatureTypes() {
        return this.features.size();
    }

    public void read(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        if (this.dict != null) {
            this.dict.read(in, this.model.numStates());
        }
        this.totalFeatures = this.featureMap.read(in);
    }

    public void write(String fileName) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        if (this.dict != null) {
            this.dict.write(out);
        }
        this.featureMap.write(out);
        out.close();
    }

    public void displayModel(double[] featureWts) throws IOException {
        this.displayModel(featureWts, System.out);
    }

    public void displayModel(double[] featureWts, PrintStream out) throws IOException {
        for (int fIndex = 0; fIndex < featureWts.length; ++fIndex) {
            Object feature = this.featureIdentifier((int)fIndex).name;
            int classIndex = this.featureIdentifier((int)fIndex).stateId;
            int label = this.model.label(classIndex);
            out.println(feature + " " + label + " " + classIndex + " " + featureWts[fIndex]);
        }
    }

    public boolean fixedTransitionFeatures() {
        return this._fixedTransitions;
    }

    class FeatureMap
    implements Serializable {
        Hashtable strToInt = new Hashtable();
        FeatureIdentifier[] idToName;

        FeatureMap() {
            FeatureGenImpl.this.featureCollectMode = true;
        }

        public int getId(FeatureImpl f) {
            int id = this.getId(f.identifier());
            if (id < 0 && FeatureGenImpl.this.featureCollectMode && (!FeatureGenImpl.this.addOnlyTrainFeatures || FeatureGenImpl.this.keepFeature(FeatureGenImpl.this.data, f))) {
                return this.add(f);
            }
            return id;
        }

        private int getId(Object key) {
            if (this.strToInt.get(key) != null) {
                return (Integer)this.strToInt.get(key);
            }
            return -1;
        }

        public int add(FeatureImpl feature) {
            int newId = this.strToInt.size();
            this.strToInt.put(feature.identifier().clone(), new Integer(newId));
            return newId;
        }

        void freezeFeatures() {
            FeatureGenImpl.this.featureCollectMode = false;
            this.idToName = new FeatureIdentifier[this.strToInt.size()];
            Enumeration e = this.strToInt.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.idToName[this.getId(key)] = (FeatureIdentifier)key;
            }
            FeatureGenImpl.this.totalFeatures = this.strToInt.size();
        }

        public int collectFeatureIdentifiers(DataIter trainData, int maxMem) throws Exception {
            trainData.startScan();
            while (trainData.hasNext()) {
                DataSequence seq = trainData.next();
                FeatureGenImpl.this.addTrainRecord(seq);
            }
            this.freezeFeatures();
            return this.strToInt.size();
        }

        public void write(PrintWriter out) throws IOException {
            out.println("******* Features ************");
            out.println(this.strToInt.size());
            Enumeration e = this.strToInt.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                out.println(key + " " + (Integer)this.strToInt.get(key));
            }
        }

        public int read(BufferedReader in) throws IOException {
            String line;
            in.readLine();
            int len = Integer.parseInt(in.readLine());
            for (int l = 0; l < len && (line = in.readLine()) != null; ++l) {
                StringTokenizer entry = new StringTokenizer(line, " ");
                FeatureIdentifier key = new FeatureIdentifier(entry.nextToken());
                int pos = Integer.parseInt(entry.nextToken());
                this.strToInt.put(key, new Integer(pos));
            }
            this.freezeFeatures();
            return this.strToInt.size();
        }

        public FeatureIdentifier getIdentifier(int id) {
            return this.idToName[id];
        }

        public String getName(int id) {
            return this.idToName[id].toString();
        }
    }
}

