/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Model.WordFeatures;
import iitb.Model.WordsInTrain;

public class KnownInOtherState
extends FeatureTypes {
    int stateId;
    WordsInTrain dict;
    float wordFreq;
    int wordPos;

    public KnownInOtherState(FeatureGenImpl m, WordsInTrain d) {
        super(m);
        this.dict = d;
    }

    void nextStateId() {
        ++this.stateId;
        while (this.stateId < this.model.numStates()) {
            if (this.dict.count(this.wordPos, this.stateId) == 0) {
                return;
            }
            ++this.stateId;
        }
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        if (this.dict.count(data.x(pos)) <= WordFeatures.RARE_THRESHOLD + 1) {
            this.stateId = this.model.numStates();
            return false;
        }
        this.wordPos = this.dict.getIndex(data.x(pos));
        this.stateId = -1;
        this.nextStateId();
        this.wordFreq = (float)Math.log((double)this.dict.count(data.x(pos)) / (double)this.dict.totalCount());
        return true;
    }

    public boolean hasNext() {
        return this.stateId < this.model.numStates();
    }

    public void next(FeatureImpl f) {
        this.setFeatureIdentifier(this.stateId, this.stateId, "K", f);
        f.yend = this.stateId;
        f.ystart = -1;
        f.val = this.wordFreq;
        this.nextStateId();
    }
}

