/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.SegmentDataSequence;
import iitb.Model.ConcatRegexFeatures;
import iitb.Model.EdgeFeatures;
import iitb.Model.EndFeatures;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureTypesEachLabel;
import iitb.Model.FeatureTypesMulti;
import iitb.Model.FeatureTypesSegmentLength;
import iitb.Model.StartFeatures;
import iitb.Model.UnknownFeature;
import iitb.Model.WindowFeatures;
import iitb.Model.WordFeatures;
import iitb.Model.WordsInTrain;
import java.util.Properties;

public class NestedFeatureGenImpl
extends FeatureGenImpl
implements FeatureGeneratorNested {
    int[] maxMem;
    int maxMemOverall = 1;

    public void addTrainRecord(DataSequence data) {
        if (this.addOnlyTrainFeatures) {
            SegmentDataSequence seq = (SegmentDataSequence)data;
            int l = 0;
            while (l < seq.length()) {
                int segEnd = seq.getSegmentEnd(l);
                this.startScanFeaturesAt(seq, l - 1, segEnd);
                while (this.hasNext()) {
                    this.next();
                }
                l = segEnd + 1;
            }
        } else {
            for (int l = 0; l < data.length(); ++l) {
                for (int m = 1; m <= this.maxMemOverall && l - m >= -1; ++m) {
                    this.startScanFeaturesAt(data, l - m, l);
                    while (this.hasNext()) {
                        this.next();
                    }
                }
            }
        }
    }

    public NestedFeatureGenImpl(int numLabels, Properties options, boolean addFeatureNow) throws Exception {
        super("naive", numLabels, false);
        if (options.getProperty("MaxMemory") != null) {
            this.maxMemOverall = Integer.parseInt(options.getProperty("MaxMemory"));
        }
        if (addFeatureNow) {
            this.addFeature(new EdgeFeatures(this));
            this.addFeature(new StartFeatures(this));
            this.addFeature(new EndFeatures(this));
            this.dict = new WordsInTrain();
            this.addFeature(new FeatureTypesMulti(new UnknownFeature(this, this.dict)));
            this.addFeature(new FeatureTypesMulti(new WordFeatures(this, this.dict)));
            this.addFeature(new FeatureTypesEachLabel(this, new FeatureTypesSegmentLength(this)));
            WindowFeatures.Window[] windows = new WindowFeatures.Window[]{new WindowFeatures.Window(0, true, 0, true, "start"), new WindowFeatures.Window(0, false, 0, false, "end"), new WindowFeatures.Window(1, true, -1, false, "continue"), new WindowFeatures.Window(-1, true, -1, true, "left-1"), new WindowFeatures.Window(1, false, 1, false, "right+1")};
            this.addFeature(new FeatureTypesEachLabel(this, new WindowFeatures(windows, new FeatureTypesMulti(new ConcatRegexFeatures(this, 0, 0)))));
        }
    }

    public NestedFeatureGenImpl(int numLabels, Properties options) throws Exception {
        this(numLabels, options, true);
    }

    public NestedFeatureGenImpl(String modelSpecs, int numLabels, boolean addFeatureNow) throws Exception {
        super(modelSpecs, numLabels, addFeatureNow);
    }

    public void startScanFeaturesAt(DataSequence data, int pos) {
        this.startScanFeaturesAt(data, pos - 1, pos);
    }

    public int maxMemory() {
        return this.maxMemOverall;
    }

    public void setMaxMemory(int i) {
        this.maxMemOverall = i;
    }

    public void startScanFeaturesAt(DataSequence d, int prevPos, int pos) {
        this.data = d;
        this.cposEnd = pos;
        this.cposStart = prevPos + 1;
        for (int i = 0; i < this.features.size(); ++i) {
            this.getFeature(i).startScanFeaturesAt(this.data, prevPos, this.cposEnd);
        }
        this.currentFeatureType = null;
        this.featureIter = this.features.iterator();
        this.advance();
    }
}

