/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import java.util.regex.Pattern;

public class RegexCountFeatures
extends FeatureTypes {
    String[][] patternString = new String[][]{{"isInitCapitalWord", "[A-Z][a-z]+"}, {"isAllCapitalWord", "[A-Z][A-Z]+"}, {"isAllSmallCase", "[a-z]+"}, {"isWord", "[a-zA-Z][a-zA-Z]+"}, {"isAlphaNumeric", "[a-zA-Z0-9]+"}, {"singleCapLetter", "[A-Z]"}, {"isSpecialCharacter", "[#;:\\-/<>'\"()&]"}, {"singleDot", "[.]"}, {"singleComma", "[,]"}, {"containsDigit", ".*\\d+.*"}, {"isDigits", "\\d+"}};
    Pattern[] p;
    int[] patternOccurence;
    int index;
    int maxSegmentLength;

    public RegexCountFeatures(FeatureGenImpl m, int maxSegmentLength) {
        super(m);
        this.maxSegmentLength = maxSegmentLength;
        this.p = new Pattern[this.patternString.length];
        for (int i = 0; i < this.patternString.length; ++i) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
        }
        this.patternOccurence = new int[this.patternString.length];
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        int j;
        for (j = 0; j < this.patternOccurence.length; ++j) {
            this.patternOccurence[j] = 0;
        }
        for (int i = prevPos + 1; i <= pos; ++i) {
            for (j = 0; j < this.p.length; ++j) {
                if (!this.p[j].matcher((String)data.x(i)).matches()) continue;
                int n = j;
                this.patternOccurence[n] = this.patternOccurence[n] + 1;
            }
        }
        this.index = -1;
        return this.advance();
    }

    private boolean advance() {
        while (++this.index < this.patternOccurence.length && this.patternOccurence[this.index] <= 0) {
        }
        return this.index < this.patternOccurence.length;
    }

    public boolean hasNext() {
        return this.index < this.patternOccurence.length;
    }

    public void next(FeatureImpl f) {
        f.val = 1.0f;
        this.patternOccurence[this.index] = Math.min(this.maxSegmentLength, this.patternOccurence[this.index]);
        f.strId.id = this.maxSegmentLength * (this.index + 1) + this.patternOccurence[this.index];
        f.ystart = -1;
        if (this.featureCollectMode()) {
            f.strId.name = this.patternString[this.index][0] + "_Count_" + this.patternOccurence[this.index];
        }
        this.advance();
    }
}

