/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataIter;
import iitb.CRF.DataSequence;
import iitb.Model.TokenGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WordsInTrain
implements Serializable {
    private Hashtable dictionary;
    private int[][] cntsArray;
    private int[] cntsOverAllWords;
    private int allTotal;
    transient TokenGenerator tokenGenerator;

    public WordsInTrain() {
        this(new TokenGenerator());
    }

    public WordsInTrain(TokenGenerator tokenGen) {
        this.tokenGenerator = tokenGen;
        this.dictionary = new Hashtable();
    }

    int[] getStateArray(int pos) {
        return this.cntsArray[pos];
    }

    public int getIndex(Object w) {
        return ((HEntry)this.dictionary.get((Object)w)).index;
    }

    boolean inDictionary(Object w) {
        return this.dictionary.get(w) != null;
    }

    public int count(Object w) {
        HEntry entry = (HEntry)this.dictionary.get(w);
        return entry != null ? entry.cnt : 0;
    }

    public int count(int wordPos, int state) {
        return this.getStateArray(wordPos)[state];
    }

    public int count(int state) {
        return this.cntsOverAllWords[state];
    }

    public int totalCount() {
        return this.allTotal;
    }

    public int dictionaryLength() {
        return this.dictionary.size();
    }

    public int nextStateWithWord(Object w, int prev) {
        if (!this.inDictionary(w)) {
            return -1;
        }
        int pos = this.getIndex(w);
        return this.nextStateWithWord(pos, prev);
    }

    public int nextStateWithWord(int pos, int prev) {
        int k = 0;
        if (prev >= 0) {
            k = prev + 1;
        }
        while (k < this.getStateArray(pos).length) {
            if (this.getStateArray(pos)[k] > 0) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public Enumeration allWords() {
        return this.dictionary.keys();
    }

    private void addDictElem(Object x, int y) {
        HEntry index = (HEntry)this.dictionary.get(x);
        if (index == null) {
            index = new HEntry(this.dictionary.size());
            this.dictionary.put(x, index);
        }
        ++index.cnt;
    }

    private void addDictElem(Object x, int y, int nelems) {
        HEntry index = (HEntry)this.dictionary.get(x);
        if (index == null) {
            index = new HEntry(this.dictionary.size(), nelems);
            this.dictionary.put(x, index);
        }
        ++index.cnt;
        int n = y;
        index.stateArray[n] = index.stateArray[n] + 1;
    }

    void setAggregateCnts(int numStates) {
        this.cntsOverAllWords = new int[numStates];
        for (int i = 0; i < numStates; ++i) {
            this.cntsOverAllWords[i] = 0;
            for (int m = 0; m < this.cntsArray.length; ++m) {
                int n = i;
                this.cntsOverAllWords[n] = this.cntsOverAllWords[n] + this.getStateArray(m)[i];
            }
            this.allTotal += this.cntsOverAllWords[i];
        }
    }

    public void train(DataIter trainData, int numStates) {
        trainData.startScan();
        while (trainData.hasNext()) {
            DataSequence seq = trainData.next();
            for (int l = 0; l < seq.length(); ++l) {
                this.tokenGenerator.startScan(seq.x(l));
                while (this.tokenGenerator.hasNext()) {
                    this.addDictElem(this.tokenGenerator.next(), seq.y(l), numStates);
                }
            }
        }
        this.cntsArray = new int[this.dictionary.size()][0];
        Enumeration e = this.dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            HEntry entry = (HEntry)this.dictionary.get(key);
            this.cntsArray[entry.index] = entry.stateArray;
        }
        this.setAggregateCnts(numStates);
    }

    public void read(BufferedReader in, int numStates) throws IOException {
        String line;
        int dictLen = Integer.parseInt(in.readLine());
        this.cntsArray = new int[dictLen][numStates];
        for (int l = 0; l < dictLen && (line = in.readLine()) != null; ++l) {
            StringTokenizer entry = new StringTokenizer(line, " ");
            String key = entry.nextToken();
            int pos = Integer.parseInt(entry.nextToken());
            HEntry hEntry = new HEntry(pos);
            this.dictionary.put(key, hEntry);
            while (entry.hasMoreTokens()) {
                int cnt;
                StringTokenizer scp = new StringTokenizer(entry.nextToken(), ":");
                int state = Integer.parseInt(scp.nextToken());
                this.getStateArray((int)pos)[state] = cnt = Integer.parseInt(scp.nextToken());
                hEntry.cnt += cnt;
            }
        }
        this.setAggregateCnts(numStates);
    }

    public void write(PrintWriter out) throws IOException {
        out.println(this.dictionary.size());
        Enumeration e = this.dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            int pos = this.getIndex(key);
            out.print(key + " " + pos);
            int s = this.nextStateWithWord(pos, -1);
            while (s != -1) {
                out.print(" " + s + ":" + this.getStateArray(pos)[s]);
                s = this.nextStateWithWord(pos, s);
            }
            out.println("");
        }
    }

    class HEntry
    implements Serializable {
        int index;
        int cnt;
        int[] stateArray;

        HEntry(int v) {
            this.index = v;
            this.cnt = 0;
        }

        HEntry(int v, int numStates) {
            this.index = v;
            this.cnt = 0;
            this.stateArray = new int[numStates];
        }
    }
}

