/*
 * Decompiled with CFR 0.152.
 */
package iitb.Segment;

import iitb.Segment.TrainRecord;

class DCTrainRecord
implements TrainRecord {
    int[] ls;
    String[][] _tokens;
    int[] labelsPerToken;
    int[] snum;
    int[] spos;

    DCTrainRecord(int[] ts, String[][] toks) {
        this.ls = ts;
        this._tokens = toks;
        int len = 0;
        for (int i = 0; i < this.numSegments(); ++i) {
            len += this._tokens[i].length;
        }
        this.labelsPerToken = new int[len];
        this.snum = new int[len];
        this.spos = new int[len];
        int pos = 0;
        for (int i = 0; i < this.ls.length; ++i) {
            int p = 0;
            while (p < this._tokens[i].length) {
                this.spos[pos] = p++;
                this.snum[pos] = i;
                this.labelsPerToken[pos++] = this.ls[i];
            }
        }
    }

    public int[] labels() {
        return this.ls;
    }

    public void set_y(int i, int l) {
        this.labelsPerToken[i] = l;
    }

    public int length() {
        return this.labelsPerToken.length;
    }

    public Object x(int i) {
        return this._tokens[this.snum[i]][this.spos[i]];
    }

    public int y(int i) {
        return this.labelsPerToken[i];
    }

    public int numSegments() {
        return this.ls.length;
    }

    public int numSegments(int l) {
        int sz = 0;
        for (int i = 0; i < this.ls.length; ++i) {
            if (this.ls[i] != l) continue;
            ++sz;
        }
        return sz;
    }

    public String[] tokens(int snum) {
        return this._tokens[snum];
    }

    public String[] tokens(int l, int p) {
        int pos = 0;
        for (int i = 0; i < this.ls.length; ++i) {
            if (this.ls[i] != l) continue;
            if (pos == p) {
                return this._tokens[i];
            }
            ++pos;
        }
        return null;
    }

    public int getSegmentEnd(int segmentStart) {
        for (int i = segmentStart + 1; i < this.length(); ++i) {
            if (this.y(i) == this.y(segmentStart)) continue;
            return i - 1;
        }
        return this.length() - 1;
    }

    public void setSegment(int segmentStart, int segmentEnd, int y) {
        for (int i = segmentStart; i <= segmentEnd; ++i) {
            this.set_y(i, y);
        }
    }
}

