/*
 * Decompiled with CFR 0.152.
 */
package jal.CHAR;

import jal.CHAR.BinaryOperator;
import jal.CHAR.BinaryPredicate;
import jal.CHAR.Generator;
import jal.CHAR.Inspection;
import jal.CHAR.Predicate;
import jal.CHAR.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(cArray, n, cArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        while (n < n2) {
            char c = cArray2[n3];
            cArray2[n3] = cArray[n];
            cArray[n] = c;
            ++n;
            ++n3;
        }
    }

    public static void transform(char[] cArray, char[] cArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            cArray2[n3++] = unaryOperator.apply(cArray[n++]);
        }
    }

    public static void transform(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            cArray3[n4++] = binaryOperator.apply(cArray[n++], cArray2[n3++]);
        }
    }

    public static void replace(char[] cArray, int n, int n2, char c, char c2) {
        while (n < n2) {
            if (cArray[n] == c) {
                cArray[n] = c2;
            }
            ++n;
        }
    }

    public static void replace_if(char[] cArray, int n, int n2, Predicate predicate, char c) {
        while (n < n2) {
            if (predicate.apply(cArray[n])) {
                cArray[n] = c;
            }
            ++n;
        }
    }

    public static void replace_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, char c, char c2) {
        while (n < n2) {
            char c3 = cArray[n++];
            char c4 = cArray2[n3++] = c3 == c ? c2 : c3;
        }
    }

    public static void replace_copy_if(char[] cArray, char[] cArray2, int n, int n2, int n3, Predicate predicate, char c) {
        while (n < n2) {
            char c2 = cArray[n++];
            char c3 = cArray2[n3++] = predicate.apply(c2) ? c : c2;
        }
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        while (n < n2) {
            cArray[n++] = c;
        }
    }

    public static void generate(char[] cArray, int n, int n2, Generator generator) {
        while (n < n2) {
            cArray[n++] = generator.apply();
        }
    }

    public static int remove_if(char[] cArray, int n, int n2, char c) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && cArray[n] != c) {
                continue;
            }
            while (n < --n2 && cArray[n2] == c) {
            }
            if (n >= n2) {
                return n;
            }
            cArray[n] = cArray[n2];
        }
    }

    public static int remove_if(char[] cArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(cArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(cArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            cArray[n] = cArray[n2];
        }
    }

    public static int stable_remove(char[] cArray, int n, int n2, char c) {
        n = Inspection.find(cArray, n, n2, c);
        int n3 = Inspection.find_not(cArray, n, n2, c);
        while (n3 < n2) {
            cArray[n++] = cArray[n3];
            ++n3;
            n3 = Inspection.find_not(cArray, n3, n2, c);
        }
        return n;
    }

    public static int stable_remove_if(char[] cArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(cArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(cArray, n, n2, predicate);
        while (n3 < n2) {
            cArray[n++] = cArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(cArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, char c) {
        while (n < n2) {
            char c2;
            if ((c2 = cArray[n++]) == c) continue;
            cArray2[n3++] = c2;
        }
        return n3;
    }

    public static int remove_copy_if(char[] cArray, char[] cArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            char c;
            if (predicate.apply(c = cArray[n++])) continue;
            cArray2[n3++] = c;
        }
        return n3;
    }

    public static int unique(char[] cArray, int n, int n2) {
        n = Inspection.adjacent_find(cArray, n, n2);
        return Modification.unique_copy(cArray, cArray, n, n2, n);
    }

    public static int unique(char[] cArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(cArray, n, n2, binaryPredicate);
        return Modification.unique_copy(cArray, cArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        cArray2[n3] = cArray[n];
        while (++n < n2) {
            if (cArray2[n3] == cArray[n]) continue;
            cArray2[++n3] = cArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        cArray2[n3] = cArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(cArray2[n3], cArray[n])) continue;
            cArray2[++n3] = cArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(char[] cArray, int n, int n2) {
        while (n < --n2) {
            char c = cArray[n];
            cArray[n++] = cArray[n2];
            cArray[n2] = c;
        }
    }

    public static void reverse_copy(char[] cArray, int n, int n2, int n3) {
        while (n2 > n) {
            cArray[n3++] = cArray[--n2];
        }
    }

    public static void reverse_copy(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        while (n2 > n) {
            cArray2[n3++] = cArray[--n2];
        }
    }

    public static void rotate(char[] cArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(cArray, n, n2);
            Modification.reverse(cArray, n2, n3);
            Modification.reverse(cArray, n, n3);
        }
    }

    public static void rotate_copy(char[] cArray, char[] cArray2, int n, int n2, int n3, int n4) {
        Modification.copy(cArray, cArray2, n2, n3, n4);
        Modification.copy(cArray, cArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(char[] cArray, int n, int n2, Random random2) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random2.nextInt()) % (n3 - n + 1);
            char c = cArray[n4];
            cArray[n4] = cArray[n3];
            cArray[n3] = c;
            ++n3;
        }
    }

    public static void random_shuffle(char[] cArray, int n, int n2) {
        Modification.random_shuffle(cArray, n, n2, default_RNG);
    }

    public static int partition(char[] cArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(cArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(cArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            char c = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c;
        }
    }

    public static int stable_partition(char[] cArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(cArray, n, n3, predicate);
            int n5 = Modification.stable_partition(cArray, n3, n2, predicate);
            Modification.rotate(cArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(cArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

