/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class CategoryTextAnnotation
extends TextAnnotation
implements CategoryAnnotation,
Cloneable,
Serializable {
    private Comparable category;
    private CategoryAnchor categoryAnchor;
    private double value;

    public CategoryTextAnnotation(String string2, Comparable comparable, double d) {
        super(string2);
        this.category = comparable;
        this.value = d;
        this.categoryAnchor = CategoryAnchor.MIDDLE;
    }

    public Comparable getCategory() {
        return this.category;
    }

    public void setCategory(Comparable comparable) {
        this.category = comparable;
    }

    public CategoryAnchor getCategoryAnchor() {
        return this.categoryAnchor;
    }

    public void setCategoryAnchor(CategoryAnchor categoryAnchor) {
        this.categoryAnchor = categoryAnchor;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void draw(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, CategoryAxis categoryAxis, ValueAxis valueAxis) {
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n = categoryDataset.getColumnIndex(this.category);
        int n2 = categoryDataset.getColumnCount();
        float f = 0.0f;
        float f2 = 0.0f;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(categoryPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(categoryPlot.getRangeAxisLocation(), plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f2 = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f = (float)valueAxis.translateValueToJava2D(this.value, rectangle2D, rectangleEdge2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.translateValueToJava2D(this.value, rectangle2D, rectangleEdge2);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        RefineryUtilities.drawRotatedString(this.getText(), graphics2D, f, f2, this.getTextAnchor(), this.getRotationAnchor(), this.getRotationAngle());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryTextAnnotation) {
            CategoryTextAnnotation categoryTextAnnotation = (CategoryTextAnnotation)object;
            if (super.equals(object)) {
                boolean bl = this.category.equals(categoryTextAnnotation.getCategory());
                boolean bl2 = this.categoryAnchor.equals(categoryTextAnnotation.getCategoryAnchor());
                boolean bl3 = this.value == categoryTextAnnotation.getValue();
                return bl && bl2 && bl3;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

