/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.XYDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;

public class BoxAndWhiskerToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    private DateFormat dateFormatter;

    public BoxAndWhiskerToolTipGenerator() {
        this(DateFormat.getInstance());
    }

    public BoxAndWhiskerToolTipGenerator(DateFormat dateFormat) {
        this.dateFormatter = dateFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string2 = null;
        if (xYDataset instanceof BoxAndWhiskerXYDataset) {
            BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
            Number number = boxAndWhiskerXYDataset.getMedianValue(n, n2);
            Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n, n2);
            Number number3 = boxAndWhiskerXYDataset.getMinRegularValue(n, n2);
            Number number4 = boxAndWhiskerXYDataset.getQ1Value(n, n2);
            Number number5 = boxAndWhiskerXYDataset.getQ3Value(n, n2);
            Number number6 = boxAndWhiskerXYDataset.getXValue(n, n2);
            string2 = boxAndWhiskerXYDataset.getSeriesName(n);
            if (number6 != null) {
                Date date = new Date(number6.longValue());
                string2 = string2 + " -> Date=" + this.dateFormatter.format(date);
                if (number != null) {
                    string2 = string2 + " Median=" + number.toString();
                }
                if (number2 != null) {
                    string2 = string2 + " Max=" + number2.toString();
                }
                if (number3 != null) {
                    string2 = string2 + " Min=" + number3.toString();
                }
                if (number4 != null) {
                    string2 = string2 + " Q1=" + number4.toString();
                }
                if (number5 != null) {
                    string2 = string2 + " Q3=" + number5.toString();
                }
            }
        }
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        BoxAndWhiskerToolTipGenerator boxAndWhiskerToolTipGenerator = (BoxAndWhiskerToolTipGenerator)super.clone();
        if (this.dateFormatter != null) {
            boxAndWhiskerToolTipGenerator.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        return boxAndWhiskerToolTipGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof BoxAndWhiskerToolTipGenerator) {
            BoxAndWhiskerToolTipGenerator boxAndWhiskerToolTipGenerator = (BoxAndWhiskerToolTipGenerator)object;
            return this.dateFormatter.equals(boxAndWhiskerToolTipGenerator.dateFormatter);
        }
        return false;
    }
}

