/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;

public class SymbolicXYToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string2;
        Object object;
        String string3;
        if (xYDataset instanceof YisSymbolic) {
            string3 = ((YisSymbolic)((Object)xYDataset)).getYSymbolicValue(n, n2);
        } else {
            object = xYDataset.getYValue(n, n2);
            string3 = Double.toString(SymbolicXYToolTipGenerator.round(((Number)object).doubleValue(), 2));
        }
        if (xYDataset instanceof XisSymbolic) {
            string2 = ((XisSymbolic)((Object)xYDataset)).getXSymbolicValue(n, n2);
        } else if (xYDataset instanceof TimeSeriesCollection) {
            object = ((TimeSeriesCollection)xYDataset).getSeries(n).getTimePeriod(n2);
            string2 = ((RegularTimePeriod)object).toString();
        } else {
            object = xYDataset.getXValue(n, n2);
            string2 = Double.toString(SymbolicXYToolTipGenerator.round(((Number)object).doubleValue(), 2));
        }
        return "X: " + string2 + ", Y: " + string3;
    }

    private static double round(double d, int n) {
        if (n <= 0) {
            return Math.floor(d + 0.5);
        }
        double d2 = Math.pow(10.0, n);
        double d3 = Math.floor(d * d2 + 0.5);
        return d3 / d2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return object instanceof SymbolicXYToolTipGenerator;
    }
}

