/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.util.ObjectUtils;

public class StandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String string2) {
        this.prefix = string2;
    }

    public StandardCategoryURLGenerator(String string2, String string3, String string4) {
        this.prefix = string2;
        this.seriesParameterName = string3;
        this.categoryParameterName = string4;
    }

    public String generateURL(CategoryDataset categoryDataset, int n, int n2) {
        String string2 = this.prefix;
        Comparable comparable = categoryDataset.getColumnKey(n2);
        boolean bl = string2.indexOf("?") == -1;
        string2 = string2 + (bl ? "?" : "&");
        string2 = string2 + this.seriesParameterName + "=" + n;
        string2 = string2 + "&" + this.categoryParameterName + "=" + comparable.toString();
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardCategoryURLGenerator) {
            StandardCategoryURLGenerator standardCategoryURLGenerator = (StandardCategoryURLGenerator)object;
            boolean bl = ObjectUtils.equal(this.prefix, standardCategoryURLGenerator.prefix);
            boolean bl2 = ObjectUtils.equal(this.seriesParameterName, standardCategoryURLGenerator.seriesParameterName);
            boolean bl3 = ObjectUtils.equal(this.categoryParameterName, standardCategoryURLGenerator.categoryParameterName);
            return bl && bl2 && bl3;
        }
        return false;
    }
}

