/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.ContourDataset;
import org.jfree.data.Range;

public class DefaultContourDataset
extends AbstractDataset
implements ContourDataset {
    protected String seriesName = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(String string2, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        this.seriesName = string2;
        this.initialize(objectArray, objectArray2, objectArray3);
    }

    public void initialize(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        int n;
        this.xValues = new Double[objectArray.length];
        this.yValues = new Double[objectArray2.length];
        this.zValues = new Double[objectArray3.length];
        Vector<Integer> vector = new Vector<Integer>();
        double d = 1.123452E31;
        for (int i = 0; i < this.xValues.length; ++i) {
            if (objectArray[i] == null) continue;
            Number number = null;
            if (objectArray[i] instanceof Number) {
                number = (Number)objectArray[i];
            } else if (objectArray[i] instanceof Date) {
                this.dateAxis[0] = true;
                Date date = (Date)objectArray[i];
                number = new Long(date.getTime());
            } else {
                number = new Integer(0);
            }
            this.xValues[i] = new Double(number.doubleValue());
            if (d == this.xValues[i].doubleValue()) continue;
            vector.add(new Integer(i));
            d = this.xValues[i].doubleValue();
        }
        Object[] objectArray4 = vector.toArray();
        this.xIndex = new int[objectArray4.length];
        for (n = 0; n < objectArray4.length; ++n) {
            this.xIndex[n] = (Integer)objectArray4[n];
        }
        for (n = 0; n < this.yValues.length; ++n) {
            this.yValues[n] = (Double)objectArray2[n];
            if (objectArray3[n] == null) continue;
            this.zValues[n] = (Double)objectArray3[n];
        }
    }

    public static Object[][] formObjectArray(double[][] dArray) {
        Object[][] objectArray = new Double[dArray.length][dArray[0].length];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                objectArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return objectArray;
    }

    public static Object[] formObjectArray(double[] dArray) {
        Object[] objectArray = new Double[dArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Double(dArray[i]);
        }
        return objectArray;
    }

    public int getItemCount(int n) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues.length;
    }

    public double getMaxZValue() {
        double d = -1.0E20;
        for (int i = 0; i < this.zValues.length; ++i) {
            if (this.zValues[i] == null) continue;
            d = Math.max(d, this.zValues[i].doubleValue());
        }
        return d;
    }

    public double getMinZValue() {
        double d = 1.0E20;
        for (int i = 0; i < this.zValues.length; ++i) {
            if (this.zValues[i] == null) continue;
            d = Math.min(d, this.zValues[i].doubleValue());
        }
        return d;
    }

    public Range getZValueRange(Range range, Range range2) {
        double d = range.getLowerBound();
        double d2 = range2.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = range2.getUpperBound();
        double d5 = 1.0E20;
        double d6 = -1.0E20;
        for (int i = 0; i < this.zValues.length; ++i) {
            if (!(this.xValues[i].doubleValue() >= d) || !(this.xValues[i].doubleValue() <= d3) || !(this.yValues[i].doubleValue() >= d2) || !(this.yValues[i].doubleValue() <= d4) || this.zValues[i] == null) continue;
            d5 = Math.min(d5, this.zValues[i].doubleValue());
            d6 = Math.max(d6, this.zValues[i].doubleValue());
        }
        return new Range(d5, d6);
    }

    public double getMinZValue(double d, double d2, double d3, double d4) {
        double d5 = 1.0E20;
        for (int i = 0; i < this.zValues.length; ++i) {
            if (this.zValues[i] == null) continue;
            d5 = Math.min(d5, this.zValues[i].doubleValue());
        }
        return d5;
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.seriesName;
    }

    public int[] getXIndices() {
        return this.xIndex;
    }

    public Number[] getXValues() {
        return this.xValues;
    }

    public Number getXValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.xValues[n2];
    }

    public Number getXValue(int n) {
        return this.xValues[n];
    }

    public Number[] getYValues() {
        return this.yValues;
    }

    public Number getYValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.yValues[n2];
    }

    public Number[] getZValues() {
        return this.zValues;
    }

    public Number getZValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues[n2];
    }

    public int[] indexX() {
        int[] nArray = new int[this.xValues.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.indexX(i);
        }
        return nArray;
    }

    public int indexX(int n) {
        int n2 = Arrays.binarySearch(this.xIndex, n);
        if (n2 >= 0) {
            return n2;
        }
        return -1 * n2 - 2;
    }

    public int indexY(int n) {
        return n / this.xValues.length;
    }

    public int indexZ(int n, int n2) {
        return this.xValues.length * n2 + n;
    }

    public boolean isDateAxis(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        return this.dateAxis[n];
    }

    public void setSeriesNames(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("Contours only support one series");
        }
        this.seriesName = stringArray[0];
        this.fireDatasetChanged();
    }
}

