/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYSeries;
import org.jfree.util.ObjectUtils;

public class DefaultTableXYDataset
extends AbstractSeriesDataset
implements TableXYDataset {
    private List data = new ArrayList();
    private List xPoints = new ArrayList();
    private boolean propagateEvents = true;

    public DefaultTableXYDataset() {
    }

    public DefaultTableXYDataset(XYSeries xYSeries) {
        if (xYSeries != null) {
            if (xYSeries.getAllowDuplicateXValues()) {
                throw new IllegalArgumentException("Cannot accept XY Series that allow duplicate values.  Use XYSeries(seriesName, false) constructor.");
            }
            this.updateXPoints(xYSeries);
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        if (xYSeries.getAllowDuplicateXValues()) {
            throw new IllegalArgumentException("Cannot accept XY Series that allow duplicate values.  Use XYSeries(seriesName, false) constructor.");
        }
        this.updateXPoints(xYSeries);
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    private void updateXPoints(XYSeries xYSeries) {
        Number number;
        int n;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        boolean bl = this.propagateEvents;
        this.propagateEvents = false;
        for (n = 0; n < xYSeries.getItemCount(); ++n) {
            number = xYSeries.getXValue(n);
            arrayList.add(number);
            if (this.xPoints.contains(number)) continue;
            this.xPoints.add(number);
            for (int i = 0; i < this.data.size(); ++i) {
                XYSeries xYSeries2 = (XYSeries)this.data.get(i);
                if (xYSeries2.equals(xYSeries)) continue;
                xYSeries2.add(number, null);
            }
        }
        for (n = 0; n < this.xPoints.size(); ++n) {
            number = (Number)this.xPoints.get(n);
            if (arrayList.contains(number)) continue;
            xYSeries.add(number, null);
        }
        this.propagateEvents = bl;
    }

    public void updateXPoints() {
        this.propagateEvents = false;
        for (int i = 0; i < this.data.size(); ++i) {
            this.updateXPoints((XYSeries)this.data.get(i));
        }
        this.propagateEvents = true;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getItemCount() {
        if (this.xPoints == null) {
            return 0;
        }
        return this.xPoints.size();
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getX();
    }

    public Number getYValue(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getY();
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            xYSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.xPoints.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            if (this.data.size() == 0) {
                this.xPoints.clear();
            }
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        if (this.data.size() == 0) {
            this.xPoints.clear();
        }
        this.fireDatasetChanged();
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        if (this.propagateEvents) {
            this.updateXPoints();
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultTableXYDataset) {
            DefaultTableXYDataset defaultTableXYDataset = (DefaultTableXYDataset)object;
            return ObjectUtils.equal(this.data, defaultTableXYDataset.data);
        }
        return false;
    }
}

