/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;

public class Hour
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_HOUR_IN_DAY = 0;
    public static final int LAST_HOUR_IN_DAY = 23;
    private Day day;
    private int hour;

    public Hour() {
        this(new Date());
    }

    public Hour(int n, Day day) {
        this.hour = n;
        this.day = day;
    }

    public Hour(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Hour(Date date, TimeZone timeZone) {
        int n;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.hour = n = calendar.get(11);
        this.day = new Day(date, timeZone);
    }

    public int getHour() {
        return this.hour;
    }

    public Day getDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDayOfMonth() {
        return this.day.getDayOfMonth();
    }

    public RegularTimePeriod previous() {
        Day day;
        Hour hour = this.hour != 0 ? new Hour(this.hour - 1, this.day) : ((day = (Day)this.day.previous()) != null ? new Hour(23, day) : null);
        return hour;
    }

    public RegularTimePeriod next() {
        Day day;
        Hour hour = this.hour != 23 ? new Hour(this.hour + 1, this.day) : ((day = (Day)this.day.next()) != null ? new Hour(0, day) : null);
        return hour;
    }

    public long getSerialIndex() {
        return this.day.getSerialIndex() * 24L + (long)this.hour;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public boolean equals(Object object) {
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            return this.hour == hour.getHour() && this.day.equals(hour.getDay());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            n = this.getDay().compareTo(hour.getDay());
            if (n == 0) {
                n = this.hour - hour.getHour();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public static Hour parseHour(String string2) {
        Hour hour = null;
        String string3 = (string2 = string2.trim()).substring(0, Math.min(10, string2.length()));
        Day day = Day.parseDay(string3);
        if (day != null) {
            String string4 = string2.substring(Math.min(string3.length() + 1, string2.length()), string2.length());
            int n = Integer.parseInt(string4 = string4.trim());
            if (n >= 0 && n <= 23) {
                hour = new Hour(n, day);
            }
        }
        return hour;
    }
}

