/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Quarter
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_QUARTER = 1;
    public static final int LAST_QUARTER = 4;
    public static final int[] FIRST_MONTH_IN_QUARTER = new int[]{0, 1, 4, 7, 10};
    public static final int[] LAST_MONTH_IN_QUARTER = new int[]{0, 3, 6, 9, 12};
    private Year year;
    private int quarter;

    public Quarter() {
        this(new Date());
    }

    public Quarter(int n, int n2) {
        this(n, new Year(n2));
    }

    public Quarter(int n, Year year) {
        if (n < 1 && n > 4) {
            throw new IllegalArgumentException("Quarter(int, Year): quarter outside valid range.");
        }
        this.year = year;
        this.quarter = n;
    }

    public Quarter(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Quarter(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        this.quarter = SerialDate.monthCodeToQuarter(n);
        this.year = new Year(calendar.get(1));
    }

    public int getQuarter() {
        return this.quarter;
    }

    public Year getYear() {
        return this.year;
    }

    public RegularTimePeriod previous() {
        Year year;
        Quarter quarter = this.quarter > 1 ? new Quarter(this.quarter - 1, this.year) : ((year = (Year)this.year.previous()) != null ? new Quarter(4, year) : null);
        return quarter;
    }

    public RegularTimePeriod next() {
        Year year;
        Quarter quarter = this.quarter < 4 ? new Quarter(this.quarter + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Quarter(1, year) : null);
        return quarter;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 4L + (long)this.quarter;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Quarter) {
                Quarter quarter = (Quarter)object;
                return this.quarter == quarter.getQuarter() && this.year.equals(quarter.getYear());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Quarter) {
            Quarter quarter = (Quarter)object;
            n = this.year.getYear() - quarter.getYear().getYear();
            if (n == 0) {
                n = this.quarter - quarter.getQuarter();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return "Q" + this.quarter + "/" + this.year;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = FIRST_MONTH_IN_QUARTER[this.quarter];
        Day day = new Day(1, n, this.year.getYear());
        return day.getFirstMillisecond(calendar);
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = LAST_MONTH_IN_QUARTER[this.quarter];
        int n2 = SerialDate.lastDayOfMonth(n, this.year.getYear());
        Day day = new Day(n2, n, this.year.getYear());
        return day.getLastMillisecond(calendar);
    }

    public static Quarter parseQuarter(String string2) throws TimePeriodFormatException {
        int n = string2.indexOf("Q");
        if (n == -1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): missing Q.");
        }
        if (n == string2.length() - 1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): Q found at end of string.");
        }
        String string3 = string2.substring(n + 1, n + 2);
        int n2 = Integer.parseInt(string3);
        String string4 = string2.substring(0, n) + string2.substring(n + 2, string2.length());
        string4 = string4.replace('/', ' ');
        string4 = string4.replace(',', ' ');
        string4 = string4.replace('-', ' ');
        Year year = Year.parseYear(string4.trim());
        Quarter quarter = new Quarter(n2, year);
        return quarter;
    }
}

