/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xml;

import java.util.Iterator;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.xml.CategoryDatasetHandler;
import org.jfree.data.xml.DatasetTags;
import org.jfree.data.xml.ItemHandler;
import org.jfree.data.xml.RootHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CategorySeriesHandler
extends DefaultHandler
implements DatasetTags {
    private RootHandler root;
    private String seriesName;
    private DefaultKeyedValues values;

    public CategorySeriesHandler(RootHandler rootHandler) {
        this.root = rootHandler;
        this.values = new DefaultKeyedValues();
    }

    public void setSeriesName(String string2) {
        this.seriesName = string2;
    }

    public void addItem(Comparable comparable, Number number) {
        this.values.addValue(comparable, number);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (string4.equals("Series")) {
            this.setSeriesName(attributes.getValue("name"));
            ItemHandler itemHandler = new ItemHandler(this.root, this);
            this.root.pushSubHandler(itemHandler);
        } else if (string4.equals("Item")) {
            ItemHandler itemHandler = new ItemHandler(this.root, this);
            this.root.pushSubHandler(itemHandler);
            itemHandler.startElement(string2, string3, string4, attributes);
        } else {
            throw new SAXException("Expecting <Series> or <Item> tag...found " + string4);
        }
    }

    public void endElement(String string2, String string3, String string4) {
        if (this.root instanceof CategoryDatasetHandler) {
            CategoryDatasetHandler categoryDatasetHandler = (CategoryDatasetHandler)this.root;
            Iterator iterator = this.values.getKeys().iterator();
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                Number number = this.values.getValue(comparable);
                categoryDatasetHandler.addItem((Comparable)((Object)this.seriesName), comparable, number);
            }
            this.root.popSubHandler();
        }
    }
}

