/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xml;

import org.jfree.data.xml.DatasetTags;
import org.jfree.data.xml.ItemHandler;
import org.jfree.data.xml.RootHandler;
import org.jfree.data.xml.ValueHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KeyHandler
extends DefaultHandler
implements DatasetTags {
    private RootHandler rootHandler;
    private ItemHandler itemHandler;
    private StringBuffer currentText;
    private Comparable key;

    public KeyHandler(RootHandler rootHandler, ItemHandler itemHandler) {
        this.rootHandler = rootHandler;
        this.itemHandler = itemHandler;
        this.currentText = new StringBuffer();
        this.key = null;
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (!string4.equals("Key")) {
            throw new SAXException("Expecting <Key> but found " + string4);
        }
        this.clearCurrentText();
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (!string4.equals("Key")) {
            throw new SAXException("Expecting </Key> but found " + string4);
        }
        this.itemHandler.setKey((Comparable)((Object)this.getCurrentText()));
        this.rootHandler.popSubHandler();
        this.rootHandler.pushSubHandler(new ValueHandler(this.rootHandler, this.itemHandler));
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.currentText != null) {
            this.currentText.append(String.copyValueOf(cArray, n, n2));
        }
    }

    protected String getCurrentText() {
        return this.currentText.toString();
    }

    protected void clearCurrentText() {
        this.currentText.delete(0, this.currentText.length());
    }
}

