/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class RectangleEdge
implements Serializable {
    public static final RectangleEdge TOP = new RectangleEdge("RectangleEdge.TOP");
    public static final RectangleEdge BOTTOM = new RectangleEdge("RectangleEdge.BOTTOM");
    public static final RectangleEdge LEFT = new RectangleEdge("RectangleEdge.LEFT");
    public static final RectangleEdge RIGHT = new RectangleEdge("RectangleEdge.RIGHT");
    private String name;

    private RectangleEdge(String string2) {
        this.name = string2;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RectangleEdge)) {
            return false;
        }
        RectangleEdge rectangleEdge = (RectangleEdge)object;
        return this.name.equals(rectangleEdge.toString());
    }

    public static boolean isTopOrBottom(RectangleEdge rectangleEdge) {
        return rectangleEdge == TOP || rectangleEdge == BOTTOM;
    }

    public static boolean isLeftOrRight(RectangleEdge rectangleEdge) {
        return rectangleEdge == LEFT || rectangleEdge == RIGHT;
    }

    public static RectangleEdge opposite(RectangleEdge rectangleEdge) {
        RectangleEdge rectangleEdge2 = null;
        if (rectangleEdge == TOP) {
            rectangleEdge2 = BOTTOM;
        } else if (rectangleEdge == BOTTOM) {
            rectangleEdge2 = TOP;
        } else if (rectangleEdge == LEFT) {
            rectangleEdge2 = RIGHT;
        } else if (rectangleEdge == RIGHT) {
            rectangleEdge2 = LEFT;
        }
        return rectangleEdge2;
    }

    public static double coordinate(Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (rectangleEdge == TOP) {
            d = rectangle2D.getMinY();
        } else if (rectangleEdge == BOTTOM) {
            d = rectangle2D.getMaxY();
        } else if (rectangleEdge == LEFT) {
            d = rectangle2D.getMinX();
        } else if (rectangleEdge == RIGHT) {
            d = rectangle2D.getMaxX();
        }
        return d;
    }
}

