/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.util.ArrayList;
import java.util.Iterator;

public class AttributeList {
    private ArrayList entryList = new ArrayList();

    public Iterator keys() {
        return new AttributeIterator(this.entryList.iterator());
    }

    public synchronized void setAttribute(String string2, String string3) {
        AttributeEntry attributeEntry = new AttributeEntry(string2, string3);
        int n = this.entryList.indexOf(attributeEntry);
        if (n != -1) {
            this.entryList.remove(n);
        }
        this.entryList.add(attributeEntry);
    }

    public synchronized String getAttribute(String string2) {
        return this.getAttribute(string2, null);
    }

    public synchronized String getAttribute(String string2, String string3) {
        int n = 0;
        while (n < this.entryList.size()) {
            AttributeEntry attributeEntry = (AttributeEntry)this.entryList.get(n);
            if (attributeEntry.getName().equals(string2)) {
                return attributeEntry.getValue();
            }
            ++n;
        }
        return string3;
    }

    public synchronized void removeAttribute(String string2) {
        int n = 0;
        while (n < this.entryList.size()) {
            AttributeEntry attributeEntry = (AttributeEntry)this.entryList.get(n);
            if (attributeEntry.getName().equals(string2)) {
                this.entryList.remove(attributeEntry);
                return;
            }
            ++n;
        }
    }

    private static class AttributeIterator
    implements Iterator {
        private Iterator backend;

        public AttributeIterator(Iterator iterator) {
            if (iterator == null) {
                throw new NullPointerException();
            }
            this.backend = iterator;
        }

        public boolean hasNext() {
            return this.backend.hasNext();
        }

        public Object next() {
            AttributeEntry attributeEntry = (AttributeEntry)this.backend.next();
            if (attributeEntry != null) {
                return attributeEntry.getName();
            }
            return attributeEntry;
        }

        public void remove() {
            this.backend.remove();
        }
    }

    private static class AttributeEntry {
        private String name;
        private String value;

        public AttributeEntry(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Name must not be null.");
            }
            if (string3 == null) {
                throw new NullPointerException("Value must not be null.");
            }
            this.name = string2;
            this.value = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributeEntry)) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)object;
            return this.name.equals(attributeEntry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

