/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

class svm_train {
    private svm_parameter param;
    private svm_problem prob;
    private svm_model model;
    private String input_file_name;
    private String model_file_name;
    private String error_msg;
    private int cross_validation;
    private int nr_fold;

    svm_train() {
    }

    private static void exit_with_help() {
        System.out.print("Usage: svm_train [options] training_set_file [model_file]\noptions:\n-s svm_type : set type of SVM (default 0)\n\t0 -- C-SVC\n\t1 -- nu-SVC\n\t2 -- one-class SVM\n\t3 -- epsilon-SVR\n\t4 -- nu-SVR\n-t kernel_type : set type of kernel function (default 2)\n\t0 -- linear: u'*v\n\t1 -- polynomial: (gamma*u'*v + coef0)^degree\n\t2 -- radial basis function: exp(-gamma*|u-v|^2)\n\t3 -- sigmoid: tanh(gamma*u'*v + coef0)\n\t4 -- precomputed kernel (kernel values in training_set_file)\n-d degree : set degree in kernel function (default 3)\n-g gamma : set gamma in kernel function (default 1/k)\n-r coef0 : set coef0 in kernel function (default 0)\n-c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)\n-n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)\n-p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)\n-m cachesize : set cache memory size in MB (default 100)\n-e epsilon : set tolerance of termination criterion (default 0.001)\n-h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)\n-b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)\n-wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)\n-v n: n-fold cross validation mode\n");
        System.exit(1);
    }

    private void do_cross_validation() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = new double[this.prob.l];
        svm.svm_cross_validation(this.prob, this.param, this.nr_fold, dArray);
        if (this.param.svm_type == 3 || this.param.svm_type == 4) {
            for (int i = 0; i < this.prob.l; ++i) {
                double d7 = this.prob.y[i];
                double d8 = dArray[i];
                d += (d8 - d7) * (d8 - d7);
                d2 += d8;
                d3 += d7;
                d4 += d8 * d8;
                d5 += d7 * d7;
                d6 += d8 * d7;
            }
            System.out.print("Cross Validation Mean squared error = " + d / (double)this.prob.l + "\n");
            System.out.print("Cross Validation Squared correlation coefficient = " + ((double)this.prob.l * d6 - d2 * d3) * ((double)this.prob.l * d6 - d2 * d3) / (((double)this.prob.l * d4 - d2 * d2) * ((double)this.prob.l * d5 - d3 * d3)) + "\n");
        } else {
            for (int i = 0; i < this.prob.l; ++i) {
                if (dArray[i] != this.prob.y[i]) continue;
                ++n;
            }
            System.out.print("Cross Validation Accuracy = " + 100.0 * (double)n / (double)this.prob.l + "%\n");
        }
    }

    private void run(String[] stringArray) throws IOException {
        this.parse_command_line(stringArray);
        this.read_problem();
        this.error_msg = svm.svm_check_parameter(this.prob, this.param);
        if (this.error_msg != null) {
            System.err.print("Error: " + this.error_msg + "\n");
            System.exit(1);
        }
        if (this.cross_validation != 0) {
            this.do_cross_validation();
        } else {
            this.model = svm.svm_train(this.prob, this.param);
            svm.svm_save_model(this.model_file_name, this.model);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        svm_train svm_train2 = new svm_train();
        svm_train2.run(stringArray);
    }

    private static double atof(String string2) {
        return Double.valueOf(string2);
    }

    private static int atoi(String string2) {
        return Integer.parseInt(string2);
    }

    private void parse_command_line(String[] stringArray) {
        int n;
        this.param = new svm_parameter();
        this.param.svm_type = 0;
        this.param.kernel_type = 2;
        this.param.degree = 3;
        this.param.gamma = 0.0;
        this.param.coef0 = 0.0;
        this.param.nu = 0.5;
        this.param.cache_size = 100.0;
        this.param.C = 1.0;
        this.param.eps = 0.001;
        this.param.p = 0.1;
        this.param.shrinking = 1;
        this.param.probability = 0;
        this.param.nr_weight = 0;
        this.param.weight_label = new int[0];
        this.param.weight = new double[0];
        this.cross_validation = 0;
        block16: for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            if (++n >= stringArray.length) {
                svm_train.exit_with_help();
            }
            switch (stringArray[n - 1].charAt(1)) {
                case 's': {
                    this.param.svm_type = svm_train.atoi(stringArray[n]);
                    continue block16;
                }
                case 't': {
                    this.param.kernel_type = svm_train.atoi(stringArray[n]);
                    continue block16;
                }
                case 'd': {
                    this.param.degree = svm_train.atoi(stringArray[n]);
                    continue block16;
                }
                case 'g': {
                    this.param.gamma = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'r': {
                    this.param.coef0 = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'n': {
                    this.param.nu = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'm': {
                    this.param.cache_size = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'c': {
                    this.param.C = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'e': {
                    this.param.eps = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'p': {
                    this.param.p = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                case 'h': {
                    this.param.shrinking = svm_train.atoi(stringArray[n]);
                    continue block16;
                }
                case 'b': {
                    this.param.probability = svm_train.atoi(stringArray[n]);
                    continue block16;
                }
                case 'v': {
                    this.cross_validation = 1;
                    this.nr_fold = svm_train.atoi(stringArray[n]);
                    if (this.nr_fold >= 2) continue block16;
                    System.err.print("n-fold cross validation: n must >= 2\n");
                    svm_train.exit_with_help();
                    continue block16;
                }
                case 'w': {
                    ++this.param.nr_weight;
                    Object[] objectArray = this.param.weight_label;
                    this.param.weight_label = new int[this.param.nr_weight];
                    System.arraycopy(objectArray, 0, this.param.weight_label, 0, this.param.nr_weight - 1);
                    objectArray = this.param.weight;
                    this.param.weight = new double[this.param.nr_weight];
                    System.arraycopy(objectArray, 0, this.param.weight, 0, this.param.nr_weight - 1);
                    this.param.weight_label[this.param.nr_weight - 1] = svm_train.atoi(stringArray[n - 1].substring(2));
                    this.param.weight[this.param.nr_weight - 1] = svm_train.atof(stringArray[n]);
                    continue block16;
                }
                default: {
                    System.err.print("unknown option\n");
                    svm_train.exit_with_help();
                }
            }
        }
        if (n >= stringArray.length) {
            svm_train.exit_with_help();
        }
        this.input_file_name = stringArray[n];
        if (n < stringArray.length - 1) {
            this.model_file_name = stringArray[n + 1];
        } else {
            int n2 = stringArray[n].lastIndexOf(47);
            this.model_file_name = stringArray[n].substring(++n2) + ".model";
        }
    }

    private void read_problem() throws IOException {
        int n;
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.input_file_name));
        Vector<String> vector = new Vector<String>();
        Vector<svm_node[]> vector2 = new Vector<svm_node[]>();
        int n2 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f:");
            vector.addElement(stringTokenizer.nextToken());
            int n3 = stringTokenizer.countTokens() / 2;
            svm_node[] svm_nodeArray = new svm_node[n3];
            for (int i = 0; i < n3; ++i) {
                svm_nodeArray[i] = new svm_node();
                svm_nodeArray[i].index = svm_train.atoi(stringTokenizer.nextToken());
                svm_nodeArray[i].value = svm_train.atof(stringTokenizer.nextToken());
            }
            if (n3 > 0) {
                n2 = Math.max(n2, svm_nodeArray[n3 - 1].index);
            }
            vector2.addElement(svm_nodeArray);
        }
        this.prob = new svm_problem();
        this.prob.l = vector.size();
        this.prob.x = new svm_node[this.prob.l][];
        for (n = 0; n < this.prob.l; ++n) {
            this.prob.x[n] = (svm_node[])vector2.elementAt(n);
        }
        this.prob.y = new double[this.prob.l];
        for (n = 0; n < this.prob.l; ++n) {
            this.prob.y[n] = svm_train.atof((String)vector.elementAt(n));
        }
        if (this.param.gamma == 0.0) {
            this.param.gamma = 1.0 / (double)n2;
        }
        if (this.param.kernel_type == 4) {
            for (n = 0; n < this.prob.l; ++n) {
                if (this.prob.x[n][0].index != 0) {
                    System.err.print("Wrong kernel matrix: first column must be 0:sample_serial_number\n");
                    System.exit(1);
                }
                if ((int)this.prob.x[n][0].value > 0 && (int)this.prob.x[n][0].value <= n2) continue;
                System.err.print("Wrong input format: sample_serial_number out of range\n");
                System.exit(1);
            }
        }
        bufferedReader.close();
    }
}

