/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;

class BSHCastExpression
extends SimpleNode {
    public BSHCastExpression(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Class clazz = ((BSHType)this.jjtGetChild(0)).getType(callStack, interpreter);
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(1);
        Object object = simpleNode.eval(callStack, interpreter);
        Class<?> clazz2 = object.getClass();
        try {
            return BSHCastExpression.castObject(object, clazz);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    public static Object castObject(Object object, Class clazz) throws UtilEvalError {
        Class<?> clazz2 = object.getClass();
        Object object2 = null;
        if (clazz.isPrimitive()) {
            if (object instanceof Primitive) {
                object2 = BSHCastExpression.castPrimitive((Primitive)object, clazz);
            } else {
                BSHCastExpression.castError(object.getClass(), clazz);
            }
        } else if (object instanceof Primitive) {
            object2 = BSHCastExpression.castPrimitive((Primitive)object, clazz);
        } else if (Capabilities.canGenerateInterfaces() && object instanceof This && clazz.isInterface()) {
            object2 = ((This)object).getInterface(clazz);
        } else if (clazz.isInstance(object)) {
            object2 = object;
        } else {
            BSHCastExpression.castError(clazz2, clazz);
        }
        if (object2 == null) {
            throw new InternalError("bad construct somewhere...");
        }
        return object2;
    }

    public static void castError(Class clazz, Class clazz2) throws UtilEvalError {
        BSHCastExpression.castError(Reflect.normalizeClassName(clazz), Reflect.normalizeClassName(clazz2));
    }

    public static void castError(String string2, String string3) throws UtilEvalError {
        ClassCastException classCastException = new ClassCastException("Illegal cast. Cannot cast " + string2 + " to " + string3);
        throw new UtilTargetError(classCastException);
    }

    public static Primitive castPrimitive(Primitive primitive, Class clazz) throws UtilEvalError {
        if (primitive == Primitive.VOID) {
            BSHCastExpression.castError("void value", Reflect.normalizeClassName(clazz));
        }
        Object object = primitive.getValue();
        Class clazz2 = primitive.getType();
        if (!clazz.isPrimitive()) {
            if (primitive != Primitive.NULL) {
                BSHCastExpression.castError("primitive value", "object type:" + clazz);
            } else {
                return primitive;
            }
        }
        if (clazz2 == Boolean.TYPE) {
            if (clazz != Boolean.TYPE) {
                BSHCastExpression.castError(clazz2, clazz);
            } else {
                return primitive;
            }
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Byte.TYPE) {
                object = new Primitive(number.byteValue());
            } else if (clazz == Short.TYPE) {
                object = new Primitive(number.shortValue());
            } else if (clazz == Character.TYPE) {
                object = new Primitive((char)number.intValue());
            } else if (clazz == Integer.TYPE) {
                object = new Primitive(number.intValue());
            } else if (clazz == Long.TYPE) {
                object = new Primitive(number.longValue());
            } else if (clazz == Float.TYPE) {
                object = new Primitive(number.floatValue());
            } else if (clazz == Double.TYPE) {
                object = new Primitive(number.doubleValue());
            } else {
                BSHCastExpression.castError(clazz2, clazz);
            }
            return (Primitive)object;
        }
        throw new UtilEvalError("unknown type in cast");
    }
}

