/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CollectionManager;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;
import java.lang.reflect.Field;

class LHS
implements ParserConstants,
Serializable {
    NameSpace nameSpace;
    boolean localVar;
    static final int VARIABLE = 0;
    static final int FIELD = 1;
    static final int PROPERTY = 2;
    static final int INDEX = 3;
    static final int METHOD_EVAL = 4;
    int type;
    String varName;
    String propName;
    Field field;
    Object object;
    int index;

    LHS(NameSpace nameSpace, String string2) {
        throw new Error("namespace lhs");
    }

    LHS(NameSpace nameSpace, String string2, boolean bl) {
        this.type = 0;
        this.localVar = bl;
        this.varName = string2;
        this.nameSpace = nameSpace;
    }

    LHS(Field field) {
        this.type = 1;
        this.object = null;
        this.field = field;
    }

    LHS(Object object, Field field) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 1;
        this.object = object;
        this.field = field;
    }

    LHS(Object object, String string2) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 2;
        this.object = object;
        this.propName = string2;
    }

    LHS(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 3;
        this.object = object;
        this.index = n;
    }

    public Object getValue() throws UtilEvalError {
        if (this.type == 0) {
            return this.nameSpace.getVariable(this.varName);
        }
        if (this.type == 1) {
            try {
                return this.field.get(this.object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UtilEvalError("Can't read field: " + this.field);
            }
        }
        if (this.type == 2) {
            try {
                return Reflect.getObjectProperty(this.object, this.propName);
            }
            catch (ReflectError reflectError) {
                Interpreter.debug(reflectError.getMessage());
                throw new UtilEvalError("No such property: " + this.propName);
            }
        }
        if (this.type == 3) {
            try {
                return Reflect.getIndex(this.object, this.index);
            }
            catch (Exception exception) {
                throw new UtilEvalError("Array access: " + exception);
            }
        }
        throw new InterpreterError("LHS type");
    }

    public Object assign(Object object, boolean bl) throws UtilEvalError {
        if (this.type == 0) {
            if (this.localVar) {
                this.nameSpace.setLocalVariable(this.varName, object, bl);
            } else {
                this.nameSpace.setVariable(this.varName, object, bl);
            }
        } else {
            if (this.type == 1) {
                try {
                    if (object instanceof Primitive) {
                        object = ((Primitive)object).getValue();
                    }
                    this.field.set(this.object, object);
                    return object;
                }
                catch (NullPointerException nullPointerException) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") not a static field.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") can't access field.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new UtilEvalError("Argument type mismatch. " + (object == null ? "null" : object.getClass().getName()) + " not assignable to field " + this.field.getName());
                }
            }
            if (this.type == 2) {
                CollectionManager collectionManager = CollectionManager.getCollectionManager();
                if (collectionManager.isMap(this.object)) {
                    collectionManager.putInMap(this.object, this.propName, object);
                } else {
                    try {
                        Reflect.setObjectProperty(this.object, this.propName, object);
                    }
                    catch (ReflectError reflectError) {
                        Interpreter.debug("Assignment: " + reflectError.getMessage());
                        throw new UtilEvalError("No such property: " + this.propName);
                    }
                }
            } else if (this.type == 3) {
                try {
                    Reflect.setIndex(this.object, this.index, object);
                }
                catch (UtilTargetError utilTargetError) {
                    throw utilTargetError;
                }
                catch (Exception exception) {
                    throw new UtilEvalError("Assignment: " + exception.getMessage());
                }
            } else {
                throw new InterpreterError("unknown lhs");
            }
        }
        return object;
    }

    public String toString() {
        return "LHS";
    }
}

