/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.LongComparator;
import cern.colt.function.LongProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.LongArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractLongList
extends AbstractList {
    protected int size;

    protected AbstractLongList() {
    }

    public void add(long l) {
        this.beforeInsert(this.size, l);
    }

    public void addAllOfFromTo(AbstractLongList abstractLongList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractLongList, n, n2);
    }

    public void beforeInsert(int n, long l) {
        this.beforeInsertDummies(n, 1);
        this.set(n, l);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractLongList abstractLongList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractLongList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(long l) {
        return this.binarySearchFromTo(l, 0, this.size - 1);
    }

    public int binarySearchFromTo(long l, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            long l2 = this.get(n5);
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            if (l2 > l) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(long l) {
        return this.indexOfFromTo(l, 0, this.size - 1) >= 0;
    }

    public void delete(long l) {
        int n = this.indexOfFromTo(l, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public long[] elements() {
        long[] lArray = new long[this.size];
        int n = this.size;
        while (--n >= 0) {
            lArray[n] = this.getQuick(n);
        }
        return lArray;
    }

    public AbstractLongList elements(long[] lArray) {
        this.clear();
        this.addAllOfFromTo(new LongArrayList(lArray), 0, lArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractLongList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractLongList abstractLongList = (AbstractLongList)object;
        if (this.size() != abstractLongList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractLongList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, long l) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, l);
        }
    }

    public boolean forEach(LongProcedure longProcedure) {
        int n = 0;
        while (n < this.size) {
            if (longProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public long get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract long getQuick(int var1);

    public int indexOf(long l) {
        return this.indexOfFromTo(l, 0, this.size - 1);
    }

    public int indexOfFromTo(long l, int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            if (l == this.getQuick(n3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        return this.lastIndexOfFromTo(l, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(long l, int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size());
        int n3 = n2;
        while (n3 >= n) {
            if (l == this.getQuick(n3)) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        long[] lArray = this.elements();
        Sorting.mergeSort(lArray, n, n2 + 1);
        this.elements(lArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, LongComparator longComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        long[] lArray = this.elements();
        Sorting.mergeSort(lArray, n, n2 + 1, longComparator);
        this.elements(lArray);
        this.setSizeRaw(n3);
    }

    public AbstractLongList partFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        LongArrayList longArrayList = new LongArrayList(n3);
        longArrayList.addAllOfFromTo(this, n, n2);
        return longArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        long[] lArray = this.elements();
        java.util.Arrays.sort(lArray, n, n2 + 1);
        this.elements(lArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, LongComparator longComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        long[] lArray = this.elements();
        Sorting.quickSort(lArray, n, n2 + 1, longComparator);
        this.elements(lArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractLongList abstractLongList) {
        if (abstractLongList.size() == 0) {
            return false;
        }
        int n = abstractLongList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractLongList.indexOfFromTo(this.getQuick(n3), 0, n) < 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractLongList abstractLongList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractLongList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractLongList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractLongList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractLongList abstractLongList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractLongList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractLongList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        int n4 = 0;
        while (n4 < n3) {
            this.set(n2++, ((Number)iterator.next()).longValue());
            ++n4;
        }
    }

    public boolean retainAll(AbstractLongList abstractLongList) {
        if (abstractLongList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n = abstractLongList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractLongList.indexOfFromTo(this.getQuick(n3), 0, n) >= 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            long l = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, l);
        }
    }

    public void set(int n, long l) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, l);
    }

    protected abstract void setQuick(int var1, long var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            long l = this.getQuick(n4);
            this.setQuick(n4, this.getQuick(n3));
            this.setQuick(n3, l);
            ++n3;
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractLongList times(int n) {
        LongArrayList longArrayList = new LongArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            longArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return longArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new Long(this.get(n2)));
            ++n2;
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

