/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird;

import edu.cmu.minorthird.classify.UI;
import edu.cmu.minorthird.ui.ApplyAnnotator;
import edu.cmu.minorthird.ui.RunMixup;
import edu.cmu.minorthird.ui.TestClassifier;
import edu.cmu.minorthird.ui.TestExtractor;
import edu.cmu.minorthird.ui.TrainClassifier;
import edu.cmu.minorthird.ui.TrainExtractor;
import edu.cmu.minorthird.ui.TrainTestClassifier;
import edu.cmu.minorthird.ui.TrainTestExtractor;
import edu.cmu.minorthird.ui.UIMain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class Minorthird
extends JFrame {
    static final long serialVersionUID = 20071015L;
    private String[] defaultArgs;

    public Minorthird(String[] args) {
        this.defaultArgs = new String[args.length + 1];
        this.defaultArgs[0] = "-gui";
        for (int i = 0; i < args.length; ++i) {
            this.defaultArgs[i + 1] = args[i];
        }
        this.initContent();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    private void initContent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.setBorder(new TitledBorder("Applications to Launch"));
        JPanel tcPanel = new JPanel();
        tcPanel.setBorder(new TitledBorder("Classify Text"));
        this.addUIButton(tcPanel, "Expt", new TrainTestClassifier());
        this.addUIButton(tcPanel, "Train", new TrainClassifier());
        this.addUIButton(tcPanel, "Test", new TestClassifier());
        panel.add(tcPanel);
        JPanel txPanel = new JPanel();
        txPanel.setBorder(new TitledBorder("Extract From Text"));
        this.addUIButton(txPanel, "Expt", new TrainTestExtractor());
        this.addUIButton(txPanel, "Train", new TrainExtractor());
        this.addUIButton(txPanel, "Test", new TestExtractor());
        panel.add(txPanel);
        JPanel cPanel = new JPanel();
        cPanel.setBorder(new TitledBorder("Non-Text Data"));
        cPanel.add(new JButton(new AbstractAction("Expt/Train/Test"){
            static final long serialVersionUID = 20071015L;

            public void actionPerformed(ActionEvent ev) {
                new UI.DataClassificationTask().callMain(Minorthird.this.defaultArgs);
            }
        }));
        panel.add(cPanel);
        JPanel oPanel = new JPanel();
        oPanel.setBorder(new TitledBorder("Execute"));
        this.addUIButton(oPanel, "Mixup", new RunMixup());
        this.addUIButton(oPanel, "Annotator", new ApplyAnnotator());
        panel.add(oPanel);
        panel.setPreferredSize(new Dimension(800, 200));
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)panel, "Center");
        this.setTitle("Minorthird LaunchPad");
        panel.revalidate();
    }

    private void addUIButton(JPanel panel, String tag, final UIMain m) {
        panel.add(new JButton(new AbstractAction(tag){
            static final long serialVersionUID = 20071015L;

            public void actionPerformed(ActionEvent ev) {
                m.callMain(Minorthird.this.defaultArgs);
            }
        }));
    }

    public static void main(String[] args) {
        new Minorthird(args);
    }
}

