/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetIndex;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.FeatureIndex;
import edu.cmu.minorthird.classify.SampleDatasets;
import java.util.Iterator;

public class BasicFeatureIndex
extends DatasetIndex
implements FeatureIndex {
    static final long serialVersionUID = 20071015L;

    public BasicFeatureIndex() {
    }

    public BasicFeatureIndex(Dataset data) {
        this();
        Iterator<Example> i = data.iterator();
        while (i.hasNext()) {
            this.addExample(i.next());
        }
    }

    public int size(Feature f, String label) {
        int size = 0;
        for (int j = 0; j < this.size(f); ++j) {
            if (!label.equals(this.getExample(f, j).getLabel().bestClassName())) continue;
            ++size;
        }
        return size;
    }

    public double getCounts(Feature f, int i) {
        return this.featureIndex(f).get(i).getWeight(f);
    }

    public double getCounts(Feature f, String label) {
        double total = 0.0;
        for (int j = 0; j < this.size(f); ++j) {
            if (!label.equals(this.getExample(f, j).getLabel().bestClassName())) continue;
            total += this.featureIndex(f).get(j).getWeight(f);
        }
        return total;
    }

    public double getDocCounts(Feature f, String label) {
        double total = 0.0;
        for (int j = 0; j < this.size(f); ++j) {
            if (!label.equals(this.getExample(f, j).getLabel().bestClassName())) continue;
            total += 1.0;
        }
        return total;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[index");
        Iterator<Feature> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            buf.append("\n" + f + ":");
            for (int j = 0; j < this.size(f); ++j) {
                buf.append("\n\t" + this.getExample(f, j).toString());
            }
            buf.append("\n\tfeature:" + f + " posCounts:" + this.getCounts(f, "POS") + " negCouns:" + this.getCounts(f, "NEG"));
        }
        buf.append("\nindex]");
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(new BasicFeatureIndex(SampleDatasets.sampleData("bayes", false)));
    }
}

