/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.algorithms.linear.NaiveBayes;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.classify.sequential.GenericCollinsLearner;
import edu.cmu.minorthird.classify.sequential.SequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.RefUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class ClassifyCommandLineUtil
extends BasicCommandLineProcessor {
    private static Dataset toDataset(String s, boolean seq, int multi) {
        boolean sequential = seq;
        try {
            if (s.startsWith("sample:")) {
                return Expt.toDataset(s);
            }
            if (sequential) {
                return DatasetLoader.loadSequence(new File(s));
            }
            if (multi > 1) {
                return DatasetLoader.loadMulti(new File(s), multi);
            }
            return DatasetLoader.loadFile(new File(s));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error loading '" + s + "': " + ex);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Error loading '" + s + "': " + ex);
        }
    }

    private static SequenceClassifierLearner toSeqLearner(String s) {
        try {
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            interp.eval("import edu.cmu.minorthird.classify.semisupervised.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            return (SequenceClassifierLearner)interp.eval(s);
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("error parsing learnerName '" + s + "':\n" + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeqTrainTestParams
    extends TrainTestParams {
        Splitter<Example[]> splitter;

        public SeqTrainTestParams() {
            this.typeString = "seq";
        }

        @Override
        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.trainDataFilename = s;
        }

        @Override
        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.testDataFilename = s;
            Iterator<Example[]> it = ((SequenceDataset)this.testData).sequenceIterator();
            this.splitter = new FixedTestSetSplitter<Example[]>(it);
        }

        @Override
        public void learner(String s) {
            this.seqLnr.seqLearner = ClassifyCommandLineUtil.toSeqLearner(s);
            this.lnr = this.seqLnr;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.trainDataFilename = s;
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.testDataFilename = s;
        }

        public Learner.SequentialLearner getLearnerParameters() {
            return this.seqLnr;
        }

        public void setLearnerParameters(Learner.SequentialLearner learn) {
            this.seqLnr = learn;
            this.lnr = this.seqLnr;
        }

        public Splitter<?> getSplitter() {
            return this.splitter;
        }

        public void setSplitter(Splitter<Example[]> s) {
            this.splitter = s;
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getTestsetFilenameHelp() {
            return "The realative path and name of the test dataset.\nSplitter will not be used if this option is defined";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a sequential experiment, so a Sequential Learner will be used.";
        }

        public String getSplitterHelp() {
            return "The splitter that defines how the training and test set will be split.";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiTrainTestParams
    extends TrainTestParams {
        Splitter<MultiExample> splitter;

        public MultiTrainTestParams() {
            this.typeString = "multi";
        }

        @Override
        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.trainDataFilename = s;
        }

        @Override
        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.testDataFilename = s;
            Iterator<MultiExample> it = ((MultiDataset)this.testData).multiIterator();
            this.splitter = new FixedTestSetSplitter<MultiExample>(it);
        }

        @Override
        public void learner(String s) {
            this.clsLnr.clsLearner = Expt.toLearner(s);
            this.lnr = this.clsLnr;
        }

        @Override
        public void multi(String dim) {
            this.multi = new Integer(dim);
        }

        @Override
        public void cross() {
            if (this.multi < 0) {
                System.out.println("Warning: Cannot use crossdimensional classification without multiLabels!");
            }
            this.crossDim = true;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.trainDataFilename = s;
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.testDataFilename = s;
        }

        public void setLearnerParameters(Learner.ClassifierLearner learn) {
            this.clsLnr = learn;
            this.lnr = this.clsLnr;
        }

        public int getMulti() {
            return this.multi;
        }

        public void setMulti(int multi) {
            this.multi = multi;
        }

        public boolean getCross() {
            return this.crossDim;
        }

        public void setCross(boolean cross) {
            this.crossDim = cross;
        }

        public Splitter<?> getSplitter() {
            return this.splitter;
        }

        public void setSplitter(Splitter<MultiExample> s) {
            this.splitter = s;
        }

        public String getMultiHelp() {
            return "The number of labels per example, or dimensions, in the dataset";
        }

        public String getCrosshelp() {
            return "Adds the predictions for each label type to the data as extra features";
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getTestsetFilenameHelp() {
            return "The realative path and name of the test dataset.\nSplitter will not be used if this option is defined";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a multi experiment, so a Classifier Learner will be used.";
        }

        public String getSplitterHelp() {
            return "The splitter that defines how the training and test set will be split.";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleTrainTestParams
    extends TrainTestParams {
        public SimpleTrainTestParams() {
            this.typeString = "simple";
        }

        @Override
        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.trainDataFilename = s;
        }

        @Override
        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.testDataFilename = s;
            Iterator<Example> it = this.testData.iterator();
            this.splitter = new FixedTestSetSplitter<Example>(it);
        }

        @Override
        public void learner(String s) {
            this.clsLnr.clsLearner = Expt.toLearner(s);
            this.lnr = this.clsLnr;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.trainDataFilename = s;
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.testDataFilename = s;
        }

        public Learner.ClassifierLearner getLearnerParameters() {
            return this.clsLnr;
        }

        public void setLearnerParameters(Learner.ClassifierLearner learn) {
            this.clsLnr = learn;
            this.lnr = this.clsLnr;
        }

        public Splitter<?> getSplitter() {
            return this.splitter;
        }

        public void setSplitter(Splitter<Example> s) {
            this.splitter = s;
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getTestsetFilenameHelp() {
            return "The realative path and name of the test dataset.\nSplitter will not be used if this option is defined";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a simple experiment, so a Classifier Learner will be used.";
        }

        public String getSplitterHelp() {
            return "The splitter that defines how the training and test set will be split.";
        }
    }

    public static class TrainTestParams
    extends TrainParams {
        public Dataset testData;
        public String testDataFilename;
        public Object resultToShow = null;
        public Object resultToSave = null;
        public BaseParams base;
        public Splitter<Example> splitter = new RandomSplitter<Example>(0.7);
        public Splitter<Example[]> sequenceSplitter = new RandomSplitter<Example[]>(0.7);
        public static TrainTestParams type = new SimpleTrainTestParams();
        public Learner.SequentialLearner seqLnr = new Learner.SequentialLearner();
        public Learner.ClassifierLearner clsLnr = new Learner.ClassifierLearner();
        public Learner lnr = this.clsLnr;
        public String typeString = "simple";

        public void type(String s) {
            this.typeString = s;
            System.out.println("Defining Type: " + s);
            if (s.equalsIgnoreCase("simple")) {
                type = new SimpleTrainTestParams();
            } else if (s.equalsIgnoreCase("seq")) {
                type = new SeqTrainTestParams();
            } else if (s.equalsIgnoreCase("multi")) {
                type = new MultiTrainTestParams();
            } else {
                System.out.println("WARN: type " + s + " is not a valid option, will use simple");
                this.typeString = "simple";
            }
        }

        public Dataset getTrainData() {
            return this.trainData;
        }

        public void data(String s) {
            type.data(s);
            this.trainData = TrainTestParams.type.trainData;
            this.trainDataFilename = TrainTestParams.type.trainDataFilename;
        }

        public void test(String s) {
            type.test(s);
            this.testData = TrainTestParams.type.testData;
            this.testDataFilename = TrainTestParams.type.testDataFilename;
            Iterator<Example> it = this.testData.iterator();
            this.splitter = new FixedTestSetSplitter<Example>(it);
        }

        public void splitter(String s) {
            TrainTestParams.type.splitter = this.splitter = Expt.toSplitter(s);
        }

        public void learner(String s) {
            type.learner(s);
            this.clsLnr.clsLearner = TrainTestParams.type.clsLnr.clsLearner;
            this.seqLnr.seqLearner = TrainTestParams.type.seqLnr.seqLearner;
            this.lnr = TrainTestParams.type.lnr;
        }

        public void multi(String dim) {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.multi(dim);
                this.multi = TrainTestParams.type.multi;
            } else {
                System.out.println("WARN: attempting to define mutli on a " + this.typeString + " experiment \n      Must define -type multi to use this option");
            }
        }

        public void cross() {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.cross();
                this.crossDim = TrainTestParams.type.crossDim;
            } else {
                System.out.println("WARN: attempting to define cross on a " + this.typeString + " experiment \n      Must define -type mutlit to use this option");
            }
        }

        public void saveAs(String s) {
            this.saveAs = new File(s);
            this.saveAsFilename = s;
            TrainTestParams.type.saveAs = this.saveAs;
            TrainTestParams.type.saveAsFilename = this.saveAsFilename;
        }

        public void showData() {
            TrainTestParams.type.showData = this.showData = true;
        }

        public void showResult() {
            TrainTestParams.type.showResult = this.showResult = true;
        }

        public void showTestDetails() {
            TrainTestParams.type.showTestDetails = this.showTestDetails = true;
        }
    }

    public static class SeqTestParams
    extends TestParams {
        public SeqTestParams() {
            this.typeString = "seq";
        }

        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.testDataFilename = s;
            Iterator<Example[]> it = ((SequenceDataset)this.testData).sequenceIterator();
            this.splitter = new FixedTestSetSplitter<Example[]>(it);
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.testDataFilename = s;
        }
    }

    public static class MultiTestParams
    extends TestParams {
        public MultiTestParams() {
            this.typeString = "multi";
        }

        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.testDataFilename = s;
            Iterator<MultiExample> it = ((MultiDataset)this.testData).multiIterator();
            this.splitter = new FixedTestSetSplitter<MultiExample>(it);
        }

        public void multi(String dim) {
            this.multi = new Integer(dim);
        }

        public void cross() {
            if (this.multi < 0) {
                System.out.println("Warning: Cannot use crossdimensional classification without multiLabels!");
            }
            this.crossDim = true;
        }

        public int getMulti() {
            return this.multi;
        }

        public void setMulti(int multi) {
            this.multi = multi;
        }

        public boolean getCross() {
            return this.crossDim;
        }

        public void setCross(boolean cross) {
            this.crossDim = cross;
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.testDataFilename = s;
        }
    }

    public static class SimpleTestParams
    extends TestParams {
        public SimpleTestParams() {
            this.typeString = "simple";
        }

        public void test(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.testDataFilename = s;
            Iterator<Example> it = this.testData.iterator();
            this.splitter = new FixedTestSetSplitter<Example>(it);
        }

        public String getTestsetFilename() {
            return this.testDataFilename;
        }

        public void setTestsetFilename(String s) {
            this.testData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.testDataFilename = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestParams
    extends BaseParams {
        public Dataset testData = null;
        public String testDataFilename = null;
        public File loadFrom = null;
        public String loadFromFilename = null;
        public Object resultToShow = null;
        public Object resultToSave = null;
        public BaseParams base;
        public Splitter<?> splitter = new RandomSplitter(0.7);
        public int multi = -1;
        public boolean crossDim = false;
        public String typeString = "simple";
        public static TestParams type = new SimpleTestParams();

        public void type(String s) {
            this.typeString = s;
            if (s.equalsIgnoreCase("simple")) {
                type = new SimpleTestParams();
            } else if (s.equalsIgnoreCase("seq")) {
                type = new SeqTestParams();
            } else if (s.equalsIgnoreCase("multi")) {
                type = new MultiTestParams();
            } else {
                System.out.println("WARN: type " + s + " is not a valid option, will use simple");
                this.typeString = "simple";
            }
        }

        public void multi(String dim) {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.multi(dim);
                this.multi = TestParams.type.multi;
            } else {
                System.out.println("WARN: attempting to define mutli on a " + this.typeString + " experiment \n      Must define -type multi to use this option");
            }
        }

        public void cross() {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.cross();
                this.crossDim = TestParams.type.crossDim;
            } else {
                System.out.println("WARN: attempting to define cross on a " + this.typeString + " experiment \n      Must define -type mutlit to use this option");
            }
        }

        public void classifierFile(String s) {
            this.loadFrom = new File(s);
            this.loadFromFilename = s;
            TestParams.type.loadFrom = this.loadFrom;
            TestParams.type.loadFromFilename = this.loadFromFilename;
        }

        public void loadFrom(String s) {
            this.loadFrom = new File(s);
            this.loadFromFilename = s;
            TestParams.type.loadFrom = this.loadFrom;
            TestParams.type.loadFromFilename = this.loadFromFilename;
        }

        public void test(String s) {
            type.test(s);
            this.testData = TestParams.type.testData;
            this.testDataFilename = TestParams.type.testDataFilename;
        }

        public void splitter(String s) {
            TestParams.type.splitter = this.splitter = Expt.toSplitter(s);
        }

        @Override
        public void saveAs(String s) {
            this.saveAs = new File(s);
            this.saveAsFilename = s;
            TestParams.type.saveAs = this.saveAs;
            TestParams.type.saveAsFilename = this.saveAsFilename;
        }

        @Override
        public void showData() {
            TestParams.type.showData = this.showData = true;
        }

        @Override
        public void showResult() {
            TestParams.type.showResult = this.showResult = true;
        }

        @Override
        public void showTestDetails() {
            TestParams.type.showTestDetails = this.showTestDetails = true;
        }

        public Splitter<?> getSplitter() {
            return this.splitter;
        }

        public void setSplitter(Splitter<Example> s) {
            TestParams.type.splitter = this.splitter = s;
        }

        public String getClassifierFilename() {
            return this.loadFromFilename;
        }

        public void setClassifierFilename(String s) {
            this.loadFromFilename = s;
            this.loadFrom = new File(s);
            TestParams.type.loadFromFilename = this.loadFromFilename;
            TestParams.type.loadFrom = this.loadFrom;
        }

        public String getMultiHelp() {
            return "The number of labels per example, or dimensions, in the dataset";
        }

        public String getCrosshelp() {
            return "Adds the predictions for each label type to the data as extra features";
        }
    }

    public static class SeqTrainParams
    extends TrainParams {
        public SeqTrainParams() {
            this.typeString = "seq";
        }

        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.trainDataFilename = s;
        }

        public void learner(String s) {
            this.seqLnr.seqLearner = ClassifyCommandLineUtil.toSeqLearner(s);
            this.lnr = this.seqLnr;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, true, -1);
            this.trainDataFilename = s;
        }

        public Learner.SequentialLearner getLearnerParameters() {
            return this.seqLnr;
        }

        public void setLearnerParameters(Learner.SequentialLearner learn) {
            this.seqLnr = learn;
            this.lnr = this.seqLnr;
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a sequential experiment, so a Sequential Learner will be used.";
        }
    }

    public static class MultiTrainParams
    extends TrainParams {
        public MultiTrainParams() {
            this.typeString = "multi";
        }

        public void multi(String dim) {
            this.multi = new Integer(dim);
        }

        public void cross() {
            if (this.multi < 0) {
                System.out.println("Warning: Cannot use crossdimensional classification without multiLabels!");
            }
            this.crossDim = true;
        }

        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.trainDataFilename = s;
        }

        public void learner(String s) {
            this.clsLnr.clsLearner = Expt.toLearner(s);
            this.lnr = this.clsLnr;
        }

        public int getMulti() {
            return this.multi;
        }

        public void setMulti(int multi) {
            this.multi = multi;
        }

        public boolean getCross() {
            return this.crossDim;
        }

        public void setCross(boolean cross) {
            this.crossDim = cross;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, this.multi);
            this.trainDataFilename = s;
        }

        public Learner.ClassifierLearner getLearnerParameters() {
            return this.clsLnr;
        }

        public void setLearnerParameters(Learner.ClassifierLearner learn) {
            this.clsLnr = learn;
            this.lnr = this.clsLnr;
        }

        public String getMultiHelp() {
            return "The number of labels per example, or dimensions, in the dataset";
        }

        public String getCrosshelp() {
            return "Adds the predictions for each label type to the data as extra features";
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a multi experiment, so a Classifier Learner will be used.";
        }
    }

    public static class SimpleTrainParams
    extends TrainParams {
        public SimpleTrainParams() {
            this.typeString = "simple";
        }

        public void data(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.trainDataFilename = s;
        }

        public void learner(String s) {
            this.clsLnr.clsLearner = Expt.toLearner(s);
            this.lnr = this.clsLnr;
        }

        public String getDatasetFilename() {
            return this.trainDataFilename;
        }

        public void setDatasetFilename(String s) {
            this.trainData = ClassifyCommandLineUtil.toDataset(s, false, -1);
            this.trainDataFilename = s;
        }

        public Learner.ClassifierLearner getLearnerParameters() {
            return this.clsLnr;
        }

        public void setLearnerParameters(Learner.ClassifierLearner learn) {
            this.clsLnr = learn;
            this.lnr = this.clsLnr;
        }

        public String getDatasetFilenameHelp() {
            return "The relative path and name of the file that contains the dataset";
        }

        public String getLearnerParametersHelp() {
            return "Defines the learner to use on the trainingData.\n  This is a simple experiment, so a Classifier Learner will be used.";
        }
    }

    public static class TrainParams
    extends BaseParams {
        public String op = "train";
        public Dataset trainData = null;
        public String trainDataFilename = null;
        public Learner.SequentialLearner seqLnr = new Learner.SequentialLearner();
        public Learner.ClassifierLearner clsLnr = new Learner.ClassifierLearner();
        public Learner lnr = this.clsLnr;
        public String typeString = "simple";
        public static TrainParams type = new SimpleTrainParams();
        public int multi = -1;
        public boolean crossDim = false;

        public void type(String s) {
            this.typeString = s;
            if (s.equalsIgnoreCase("simple")) {
                type = new SimpleTrainParams();
            } else if (s.equalsIgnoreCase("seq")) {
                type = new SeqTrainParams();
            } else if (s.equalsIgnoreCase("multi")) {
                type = new MultiTrainParams();
            } else {
                System.out.println("WARN: type " + s + " is not a valid option, will use simple");
                this.typeString = "simple";
            }
        }

        public void multi(String dim) {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.multi(dim);
                this.multi = TrainParams.type.multi;
            } else {
                System.out.println("WARN: attempting to define mutli on a " + this.typeString + " experiment \n      Must define -type multi to use this option");
            }
        }

        public void cross() {
            if (this.typeString.equalsIgnoreCase("multi")) {
                type.cross();
                this.crossDim = TrainParams.type.crossDim;
            } else {
                System.out.println("WARN: attempting to define cross on a " + this.typeString + " experiment \n      Must define -type mutlit to use this option");
            }
        }

        public void data(String s) {
            type.data(s);
            this.trainData = TrainParams.type.trainData;
            this.trainDataFilename = TrainParams.type.trainDataFilename;
        }

        public void learner(String s) {
            type.learner(s);
            this.clsLnr.clsLearner = TrainParams.type.clsLnr.clsLearner;
            this.seqLnr.seqLearner = TrainParams.type.seqLnr.seqLearner;
            this.lnr = TrainParams.type.lnr;
        }

        public void saveAs(String s) {
            this.saveAs = new File(s);
            this.saveAsFilename = s;
            TrainParams.type.saveAs = this.saveAs;
            TrainParams.type.saveAsFilename = this.saveAsFilename;
        }

        public void showData() {
            TrainParams.type.showData = this.showData = true;
        }

        public void showResult() {
            TrainParams.type.showResult = this.showResult = true;
        }

        public void showTestDetails() {
            TrainParams.type.showTestDetails = this.showTestDetails = true;
        }
    }

    public static class BaseParams
    extends BasicCommandLineProcessor {
        public boolean showData = false;
        public boolean showTestDetails;
        public File saveAs;
        public String saveAsFilename;
        public Object resultToShow = null;
        public Object resultToSave = null;
        public boolean showResult = false;

        public void saveAs(String s) {
            this.saveAs = new File(s);
            this.saveAsFilename = s;
        }

        public void showData() {
            this.showData = true;
        }

        public void showResult() {
            this.showResult = true;
        }

        public void showTestDetails() {
            this.showTestDetails = true;
        }

        public void other(String s) {
            BaseParams o = this;
            RefUtils.modify(o, s);
        }

        public String getSaveAsFilename() {
            return this.saveAsFilename;
        }

        public void setSaveAsFilename(String s) {
            this.saveAsFilename = s;
            this.saveAs = new File(s);
        }

        public boolean getShowTestDetails() {
            return this.showTestDetails;
        }

        public void setShowTestDetails(boolean flag) {
            this.showTestDetails = flag;
        }

        public boolean getShowData() {
            return this.showData;
        }

        public void setShowData(boolean show) {
            this.showData = show;
        }

        public String getSaveAsFilenameHelp() {
            return "The name of the file where the result will be sotred";
        }

        public String getShowTestDetailsHelp() {
            return "Visualize Details, such as the classifier, with results";
        }

        public String getShowDataHelp() {
            return "Open a window with the Dataset";
        }
    }

    public static class Learner
    extends BasicCommandLineProcessor {

        public static class ClassifierLearner
        extends Learner {
            public edu.cmu.minorthird.classify.ClassifierLearner clsLearner = new NaiveBayes();

            public edu.cmu.minorthird.classify.ClassifierLearner getLearner() {
                return this.clsLearner;
            }

            public void setLearner(edu.cmu.minorthird.classify.ClassifierLearner c) {
                this.clsLearner = c;
            }
        }

        public static class SequentialLearner
        extends Learner {
            public SequenceClassifierLearner seqLearner = new GenericCollinsLearner();

            public SequenceClassifierLearner getLearnerInSequentialMode() {
                return this.seqLearner;
            }

            public void setLearnerInSequentialMode(SequenceClassifierLearner c) {
                this.seqLearner = c;
            }
        }
    }
}

