/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.util.MathUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.Visible;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectDoubleIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hyperplane
extends BinaryClassifier
implements Visible,
Serializable {
    private static final long serialVersionUID = 20080128L;
    public static final Feature BIAS_TERM = new Feature("_hyperplaneBias");
    protected transient TObjectDoubleHashMap hyperplaneWeights = new TObjectDoubleHashMap();
    private transient boolean ignoreWeights = false;

    private void writeObject(ObjectOutputStream out) throws IOException {
        Iterator<Feature> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            double w = this.featureScore(f);
            if (w == 0.0) continue;
            out.writeObject(f);
            out.writeDouble(w);
        }
        out.writeObject(BIAS_TERM);
        out.writeDouble(0.0);
        out.writeBoolean(this.ignoreWeights);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            double w = 1.0;
            this.hyperplaneWeights = new TObjectDoubleHashMap();
            while (w != 0.0) {
                Feature f = (Feature)in.readObject();
                w = in.readDouble();
                if (w == 0.0) continue;
                this.hyperplaneWeights.put(f, w);
            }
            this.ignoreWeights = in.readBoolean();
        }
        catch (StreamCorruptedException ex) {
            in.defaultReadObject();
        }
    }

    public void startIgnoringWeights() {
        this.ignoreWeights = true;
    }

    @Override
    public double score(Instance instance) {
        double score = 0.0;
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            score += instance.getWeight(f) * this.featureScore(f);
        }
        return score += this.featureScore(BIAS_TERM);
    }

    @Override
    public String explain(Instance instance) {
        StringBuffer buf = new StringBuffer("");
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            if (buf.length() > 0) {
                buf.append("\n + ");
            } else {
                buf.append("   ");
            }
            buf.append(f + "<" + instance.getWeight(f) + "*" + this.featureScore(f) + ">");
        }
        buf.append("\n + bias<" + this.featureScore(BIAS_TERM) + ">");
        buf.append("\n = " + this.score(instance));
        return buf.toString();
    }

    @Override
    public Explanation getExplanation(Instance instance) {
        Explanation.Node top = new Explanation.Node("Hyperplane Explanation");
        Explanation.Node tokens = new Explanation.Node("Tokens:");
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            Explanation.Node ftr = new Explanation.Node(f + "<" + instance.getWeight(f) + "*" + this.featureScore(f) + ">");
            tokens.add(ftr);
        }
        Explanation.Node bias = new Explanation.Node("bias<" + this.featureScore(BIAS_TERM) + ">");
        tokens.add(bias);
        top.add(tokens);
        Explanation.Node score = new Explanation.Node("\n = " + this.score(instance));
        top.add(score);
        Explanation ex = new Explanation(top);
        return ex;
    }

    public void increment(Feature f, double delta) {
        double d = this.hyperplaneWeights.get(f);
        this.hyperplaneWeights.put(f, d + delta);
    }

    public void incrementBias(double delta) {
        this.increment(BIAS_TERM, delta);
    }

    public void setBias(double delta) {
        this.hyperplaneWeights.remove(BIAS_TERM);
        this.hyperplaneWeights.put(BIAS_TERM, delta);
    }

    public void increment(Instance instance, double delta) {
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            double w = this.ignoreWeights ? 1.0 : instance.getWeight(f);
            this.increment(f, w * delta);
        }
        this.incrementBias(delta);
    }

    public void multiply(double factor) {
        Iterator<Feature> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            this.hyperplaneWeights.put(f, this.featureScore(f) * factor);
        }
    }

    public void multiply(Feature f, double delta) {
        double d = this.hyperplaneWeights.get(f);
        this.hyperplaneWeights.put(f, d * delta);
    }

    public boolean hasFeature(Feature feat) {
        return this.hyperplaneWeights.containsKey(feat);
    }

    public void increment(Hyperplane b, double delta) {
        TObjectDoubleIterator i = b.hyperplaneWeights.iterator();
        while (i.hasNext()) {
            i.advance();
            Feature f = (Feature)i.key();
            double w = b.featureScore(f);
            this.increment(f, w * delta);
        }
    }

    public void increment(Hyperplane b) {
        this.increment(b, 1.0);
    }

    public double featureScore(Feature feature) {
        return this.hyperplaneWeights.get(feature);
    }

    public Iterator<Feature> featureIterator() {
        final TObjectDoubleIterator ti = this.hyperplaneWeights.iterator();
        Iterator<Feature> i = new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return ti.hasNext();
            }

            @Override
            public Feature next() {
                ti.advance();
                return (Feature)ti.key();
            }

            @Override
            public void remove() {
                ti.remove();
            }
        };
        return i;
    }

    @Override
    public Viewer toGUI() {
        ControlledViewer gui = new ControlledViewer(new MyViewer(), new HyperplaneControls());
        gui.setContent(this);
        return gui;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[Hyperplane:");
        Iterator<Feature> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            buf.append(" " + f + "=" + this.featureScore(f));
        }
        buf.append("]");
        return buf.toString();
    }

    private static class MyViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 20080128L;
        private HyperplaneControls controls = null;
        private Hyperplane h = null;

        private MyViewer() {
        }

        public void applyControls(ViewerControls controls) {
            this.controls = (HyperplaneControls)controls;
            this.setContent(this.h, true);
            this.revalidate();
        }

        public boolean canReceive(Object o) {
            return o instanceof Hyperplane;
        }

        public void createNodes(DefaultMutableTreeNode top, Object[][] data, int start, int len, int level) {
            int size = ((Feature)data[start][0]).size();
            double max = (Double)data[start][1];
            if (level <= size) {
                String tok = ((Feature)data[start][0]).getPart(level);
                int i = start + 1;
                String nextTok = ((Feature)data[i][0]).getPart(level);
                double weight = (Double)data[i][1];
                boolean flag = false;
                while (nextTok.equals(tok) && i < len - 1) {
                    if (weight > max) {
                        max = weight;
                    }
                    nextTok = ((Feature)data[++i][0]).getPart(level);
                    weight = (Double)data[i][1];
                    flag = true;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(tok + " (" + max + ")");
                top.add(node);
                if (flag) {
                    this.createNodes(node, data, start, i, level + 1);
                }
                if (i < len - 1) {
                    this.createNodes(top, data, i, len, level);
                }
            }
        }

        public JTree createTree(Object[][] data, int len) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode("Features Tree");
            this.createNodes(top, data, 0, len, 0);
            JTree tree = new JTree(top);
            return tree;
        }

        public JComponent componentFor(Object o) {
            this.h = (Hyperplane)o;
            Object[] keys = this.h.hyperplaneWeights.keys();
            Object[][] tableData = new Object[keys.length][2];
            int k = 0;
            Iterator<Feature> i = this.h.featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                tableData[k][0] = f;
                tableData[k][1] = new Double(this.h.featureScore(f));
                ++k;
            }
            if (this.controls != null) {
                Arrays.sort(tableData, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] ra, Object[] rb) {
                        if (MyViewer.this.controls.nameButton.isSelected() || MyViewer.this.controls.treeButton.isSelected()) {
                            return ra[0].toString().compareTo(rb[0].toString());
                        }
                        Double da = (Double)ra[1];
                        Double db = (Double)rb[1];
                        if (MyViewer.this.controls.valueButton.isSelected()) {
                            return MathUtil.sign(db - da);
                        }
                        return MathUtil.sign(Math.abs(db) - Math.abs(da));
                    }
                });
                if (this.controls.treeButton.isSelected()) {
                    JTree tree = this.createTree(tableData, keys.length);
                    return new JScrollPane(tree);
                }
            }
            Object[] columnNames = new String[]{"Feature Name", "Weight"};
            JTable table = new JTable(tableData, columnNames);
            this.monitorSelections(table, 0);
            return new JScrollPane(table);
        }
    }

    private static class HyperplaneControls
    extends ViewerControls {
        static final long serialVersionUID = 20080128L;
        private JRadioButton valueButton;
        private JRadioButton nameButton;
        private JRadioButton treeButton;

        private HyperplaneControls() {
        }

        public void initialize() {
            ButtonGroup group = new ButtonGroup();
            this.treeButton = this.addButton("Tree view", group, false);
            this.add(new JLabel("   OR  "));
            this.add(new JLabel("   Sort by"));
            this.nameButton = this.addButton("name", group, true);
            this.valueButton = this.addButton("weight", group, false);
        }

        private JRadioButton addButton(String s, ButtonGroup group, boolean selected) {
            JRadioButton button = new JRadioButton(s, selected);
            group.add(button);
            this.add(button);
            button.addActionListener(this);
            return button;
        }
    }
}

