/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class KernelVotedPerceptron
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080128L;
    private static Logger log = Logger.getLogger(KernelVotedPerceptron.class);
    private Hyperplane v_k;
    private int c_k;
    private List<Hyperplane> listVK;
    private List<Integer> listCK;
    private String mode = "voted";
    private int degree = 3;
    private double gamma = 10.0;
    private double coef0 = 1.0;
    private boolean speedup = false;
    private int MAXVEC = 300;

    public KernelVotedPerceptron(int degree, String mode) {
        this.reset();
        this.degree = degree;
        this.mode = mode;
    }

    public KernelVotedPerceptron() {
        this.reset();
    }

    public void setKernel(int d) {
        this.degree = d;
    }

    public void setPolyKernelParams(double coef0, double gamma) {
        this.coef0 = coef0;
        this.gamma = gamma;
    }

    public void reset() {
        this.v_k = new Hyperplane();
        this.listVK = new ArrayList<Hyperplane>();
        this.listCK = new ArrayList<Integer>();
        this.c_k = 0;
    }

    public void setModeVoted() {
        this.mode = "voted";
    }

    public void setModeAveraged() {
        this.mode = "averaged";
    }

    public void setSpeedUp() {
        this.speedup = true;
    }

    private void store(Hyperplane h, int count) {
        Hyperplane hh = new Hyperplane();
        hh.increment(h);
        this.listVK.add(hh);
        this.listCK.add(new Integer(count));
    }

    public void addExample(Example example) {
        double y_t = example.getLabel().numericLabel();
        if (this.Kernel(this.v_k, example.asInstance()) * y_t <= 0.0) {
            this.store(this.v_k, this.c_k);
            this.v_k.increment(example, y_t);
            this.c_k = 1;
        } else {
            ++this.c_k;
        }
    }

    double Kernel(Hyperplane h, Instance ins) {
        double score = h.score(ins);
        if (this.degree == 0) {
            return score;
        }
        return Math.pow(this.coef0 + score * this.gamma, this.degree);
    }

    public Classifier getClassifier() {
        return new MyClassifier(this.listVK, this.listCK);
    }

    public String toString() {
        return "Kernel Voted Perceptron";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyClassifier
    implements Classifier,
    Serializable,
    Visible {
        private static final long serialVersionUID = 1L;
        List<Hyperplane> listVK;
        List<Integer> counts;

        public MyClassifier(List<Hyperplane> li, List<Integer> cc) {
            this.listVK = li;
            this.counts = cc;
            log.info("info: KernelVotedPerceptron: number sup vectors = " + this.listVK.size() + " mode=" + KernelVotedPerceptron.this.mode + " kernel=" + KernelVotedPerceptron.this.degree);
        }

        @Override
        public ClassLabel classification(Instance ins) {
            double dec = 0.0;
            if (KernelVotedPerceptron.this.mode.equalsIgnoreCase("voted")) {
                dec = this.calculateVoted(ins);
            } else if (KernelVotedPerceptron.this.mode.equalsIgnoreCase("averaged")) {
                dec = this.calculateAveraged(ins);
            } else {
                System.out.println("Mode(" + KernelVotedPerceptron.this.mode + ") is not allowed\n Please use either \"voted\" or \"averaged\"");
                System.exit(0);
            }
            return dec >= 0.0 ? ClassLabel.positiveLabel(dec) : ClassLabel.negativeLabel(dec);
        }

        private double calculateVoted(Instance ins) {
            double score = 0.0;
            int FIRSTVEC = 0;
            if (KernelVotedPerceptron.this.speedup) {
                int MAX = Math.min(KernelVotedPerceptron.this.MAXVEC, this.listVK.size());
                FIRSTVEC = this.listVK.size() - MAX;
            }
            for (int i = FIRSTVEC; i < this.listVK.size(); ++i) {
                Hyperplane v_k = this.listVK.get(i);
                int countt = this.counts.get(i);
                double kernelScore = KernelVotedPerceptron.this.Kernel(v_k, ins);
                double sign = kernelScore > 0.0 ? 1.0 : -1.0;
                score += (double)countt * sign;
            }
            return score;
        }

        private double calculateAveraged(Instance ins) {
            double score = 0.0;
            int FIRSTVEC = 0;
            if (KernelVotedPerceptron.this.speedup) {
                int MAX = Math.min(KernelVotedPerceptron.this.MAXVEC, this.listVK.size());
                FIRSTVEC = this.listVK.size() - MAX;
            }
            for (int i = FIRSTVEC; i < this.listVK.size(); ++i) {
                Hyperplane hp = this.listVK.get(i);
                int countt = this.counts.get(i);
                score += (double)countt * KernelVotedPerceptron.this.Kernel(hp, ins);
            }
            return score;
        }

        @Override
        public String explain(Instance instance) {
            return "KernelVotedPerceptron: Not implemented yet";
        }

        @Override
        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("Kernel Perceptron Explanation (not valid!)");
            Explanation ex = new Explanation(top);
            return ex;
        }

        @Override
        public Viewer toGUI() {
            TransformedViewer v = new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080128L;

                public Object transform(Object o) {
                    MyClassifier mycl = (MyClassifier)o;
                    Hyperplane hh = mycl.listVK.get(MyClassifier.this.listVK.size() - 1);
                    return hh;
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

