/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import java.io.Serializable;
import java.util.Iterator;

public class PassiveAggressiveLearner
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private Hyperplane pos_t;
    private Hyperplane vpos_t;
    private double eta;
    private double gamma;
    private int excount;
    private boolean voted;

    public PassiveAggressiveLearner() {
        this(1.0, 0.1, true);
    }

    public PassiveAggressiveLearner(double eta, double gamma, boolean voted) {
        this.eta = eta;
        this.gamma = gamma;
        this.voted = voted;
        this.reset();
    }

    public void reset() {
        this.pos_t = new Hyperplane();
        if (this.voted) {
            this.vpos_t = new Hyperplane();
        }
    }

    public void addExample(Example example) {
        double y_t_hat;
        ++this.excount;
        double y_t = example.getLabel().numericLabel();
        if (y_t * (y_t_hat = this.pos_t.score(example.asInstance())) < this.eta) {
            double loss = this.eta - y_t * y_t_hat;
            double normsqr = this.getNormSquared(example.asInstance());
            double weight = y_t * (loss / (normsqr + this.gamma));
            this.pos_t.increment(example.asInstance(), weight);
        }
        if (this.voted) {
            this.vpos_t.increment(this.pos_t, 1.0);
        }
    }

    public double getNormSquared(Instance ins) {
        double tmp = 0.0;
        Iterator<Feature> j = ins.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            double val = ins.getWeight(f);
            tmp += val * val;
        }
        return tmp;
    }

    public Classifier getClassifier() {
        Hyperplane z = new Hyperplane();
        if (this.voted) {
            z.increment(this.vpos_t);
        } else {
            z.increment(this.pos_t);
        }
        return z;
    }

    public String toString() {
        return "PassiveAggressive Algorithm";
    }

    public static void main(String[] args) {
        PassiveAggressiveLearner pa = new PassiveAggressiveLearner();
        ClassLabel c = ClassLabel.positiveLabel(1.0);
        MutableInstance instance = new MutableInstance();
        instance.addNumeric(new Feature("f2"), 2.0);
        instance.addNumeric(new Feature("f3"), 3.0);
        instance.addNumeric(new Feature("f4"), 4.0);
        Example ex = new Example(instance, c);
        pa.addExample(ex);
        Classifier hp = pa.getClassifier();
        System.out.println("Winnow Hyperplane = " + hp.toString());
        ClassLabel c1 = ClassLabel.negativeLabel(-1.0);
        MutableInstance instance1 = new MutableInstance();
        instance1.addNumeric(new Feature("f3"), 1.0);
        instance1.addNumeric(new Feature("f4"), 2.0);
        instance1.addNumeric(new Feature("f5"), 3.0);
        Example ex1 = new Example(instance1, c1);
        pa.addExample(ex1);
        hp = pa.getClassifier();
        System.out.println("Winnow Hyperplane = " + hp.toString());
        ClassLabel c2 = ClassLabel.positiveLabel(1.0);
        MutableInstance instance2 = new MutableInstance();
        instance2.addNumeric(new Feature("f3"), -5.0);
        instance2.addNumeric(new Feature("f4"), -12.0);
        instance2.addNumeric(new Feature("f5"), -34.0);
        Example ex2 = new Example(instance2, c2);
        pa.addExample(ex2);
        hp = pa.getClassifier();
        System.out.println("Winnow Hyperplane = " + hp.toString());
        ClassLabel c3 = ClassLabel.positiveLabel(1.0);
        MutableInstance instance3 = new MutableInstance();
        instance3.addNumeric(new Feature("f3"), -5.0);
        instance3.addNumeric(new Feature("f4"), -12.0);
        instance3.addNumeric(new Feature("f5"), -34.0);
        instance.addNumeric(new Feature("f2"), -2.0);
        Example ex3 = new Example(instance3, c3);
        pa.addExample(ex3);
        hp = pa.getClassifier();
        System.out.println("Winnow Hyperplane = " + hp.toString());
    }
}

