/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.linear.Winnow;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegretWinnow
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private Hyperplane pos_t;
    private Hyperplane numGivenPos;
    private Hyperplane numGivenNeg;
    private Hyperplane vpos_t;
    private double theta = 1.0;
    private double alpha;
    private double beta;
    private int excount;
    private double margin = 0.0;
    private boolean voted;
    private boolean regret;
    private Hyperplane lossH;
    private Hyperplane lossF;
    private double W_MAX = Math.pow(2.0, 200.0);
    private double W_MIN = 1.0 / Math.pow(2.0, 200.0);
    double beta2 = 0.95;
    private int votedCount = 0;
    private int mode;
    private final int LIST_SIZE = 5;
    private Map<Feature, List<ClassLabel>> fmap;

    public RegretWinnow() {
        this(1.5, 0.5, false, 1);
    }

    public RegretWinnow(double a, double b, boolean voted, int mode) {
        if (a < 1.0 || b < 0.0 || b > 1.0) {
            System.out.println("Error in BalancedWinnow initial parameters");
            System.out.println("Possible problem: (theta<0)||(alpha < 1)||(beta<0)||(beta>1)");
            System.exit(0);
        }
        this.alpha = a;
        this.beta = b;
        this.voted = voted;
        if (mode == 0) {
            this.regret = false;
        } else {
            this.regret = true;
            this.mode = mode;
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.pos_t = new Hyperplane();
        this.excount = 0;
        this.votedCount = 0;
        if (this.voted) {
            this.vpos_t = new Hyperplane();
        }
        if (this.regret) {
            this.lossH = new Hyperplane();
            this.lossF = new Hyperplane();
            if (this.mode == 4) {
                this.fmap = new HashMap<Feature, List<ClassLabel>>();
            }
            if (this.mode == 2) {
                this.numGivenPos = new Hyperplane();
                this.numGivenNeg = new Hyperplane();
            }
        }
    }

    @Override
    public void addExample(Example example2) {
        Iterator<Feature> j;
        double y_t_hat;
        ++this.excount;
        Example example = Winnow.normalizeWeights(example2, true);
        Iterator<Feature> j2 = example.asInstance().featureIterator();
        while (j2.hasNext()) {
            Feature f = j2.next();
            if (this.mode == 2) {
                if (example.getLabel().isPositive()) {
                    this.numGivenPos.increment(f, 1.0);
                } else {
                    this.numGivenNeg.increment(f, 1.0);
                }
            }
            if (!this.pos_t.hasFeature(f)) {
                this.pos_t.increment(f, 1.0);
                if (this.mode == 4 && !this.fmap.containsKey(f)) {
                    ArrayList mylist = new ArrayList(6);
                    this.fmap.put(f, mylist);
                }
            }
            if (this.mode != 4) continue;
            List<ClassLabel> ll = this.fmap.get(f);
            ll.add(0, example.getLabel());
            if (ll.size() <= 6) continue;
            ll.remove(6);
        }
        double y_t = example.getLabel().numericLabel();
        if (y_t * (y_t_hat = this.pos_t.score(example.asInstance()) - this.theta) <= this.margin) {
            Feature f;
            if (this.voted) {
                if (this.votedCount == 0) {
                    this.updateVotedHyperplane(1);
                } else {
                    this.updateVotedHyperplane(this.votedCount);
                }
                this.votedCount = 1;
            }
            if (example.getLabel().isPositive()) {
                j = example.featureIterator();
                while (j.hasNext()) {
                    f = j.next();
                    if (!(this.pos_t.featureScore(f) < this.W_MAX)) continue;
                    this.pos_t.multiply(f, this.alpha);
                }
            } else {
                j = example.featureIterator();
                while (j.hasNext()) {
                    f = j.next();
                    if (!(this.pos_t.featureScore(f) > this.W_MIN)) continue;
                    this.pos_t.multiply(f, this.beta);
                }
            }
        } else if (this.voted) {
            ++this.votedCount;
        }
        if (this.regret) {
            j = example.featureIterator();
            while (j.hasNext()) {
                double deltaLoss;
                double factor;
                List<ClassLabel> lu;
                int deci;
                double localF = 0.0;
                double localH = 0.0;
                Feature ff = j.next();
                if (!(y_t * y_t_hat > this.margin)) {
                    this.lossH.increment(ff, 1.0);
                    localH += 1.0;
                }
                if (this.mode == 1 && !(y_t * example.getWeight(ff) > 0.0)) {
                    this.lossF.increment(ff, 1.0);
                    localF += 1.0;
                }
                if (this.mode == 2) {
                    double coef;
                    double posFactor = this.numGivenPos.featureScore(ff);
                    double negFactor = this.numGivenNeg.featureScore(ff);
                    double total = posFactor + negFactor;
                    if (example.getLabel().isPositive()) {
                        coef = 1.0 - posFactor / total;
                        this.lossF.increment(ff, coef);
                    } else {
                        coef = 1.0 - negFactor / total;
                        this.lossF.increment(ff, coef);
                    }
                }
                if (this.mode == 3) {
                    int exampleSize = example2.numFeatures();
                    if (example.getLabel().isNegative() && example.getWeight(ff) * this.pos_t.featureScore(ff) * (double)exampleSize > 1.0) {
                        this.lossF.increment(ff, 1.0);
                        localF += 1.0;
                    } else if (example.getLabel().isPositive() && example.getWeight(ff) * this.pos_t.featureScore(ff) * (double)exampleSize < 1.0) {
                        this.lossF.increment(ff, 1.0);
                        localF += 1.0;
                    }
                }
                if (this.mode == 4 && !(y_t * (double)(deci = this.getHistory(lu = this.fmap.get(ff))) >= 0.0)) {
                    this.lossF.increment(ff, 1.0);
                    localF += 1.0;
                }
                if (this.mode == 5) {
                    this.lossF.increment(ff, Math.random());
                }
                if ((factor = Math.pow(this.beta2, deltaLoss = this.lossF.featureScore(ff) - this.beta2 * this.lossH.featureScore(ff))) > 1.0 && factor < this.W_MAX) {
                    if (!(this.pos_t.featureScore(ff) < this.W_MAX)) continue;
                    this.pos_t.multiply(ff, factor);
                    continue;
                }
                if (!(factor < 1.0) || !(factor > this.W_MIN) || !(this.pos_t.featureScore(ff) > this.W_MIN)) continue;
                this.pos_t.multiply(ff, factor);
            }
        }
    }

    public void updateVotedHyperplane(int count) {
        this.vpos_t.increment(this.pos_t, (double)count);
        this.votedCount = 0;
    }

    @Override
    public Classifier getClassifier() {
        if (this.voted) {
            this.updateVotedHyperplane(this.votedCount);
            Hyperplane zpos = new Hyperplane();
            zpos.increment(this.vpos_t, 1.0 / (double)this.excount);
            return new MyClassifier(zpos, this.theta);
        }
        return new MyClassifier(this.pos_t, this.theta);
    }

    public int getHistory(List<ClassLabel> ll) {
        int tmp = 0;
        for (int i = 1; i < ll.size(); ++i) {
            if (ll.get(i).isPositive()) {
                ++tmp;
                continue;
            }
            --tmp;
        }
        return tmp == 0 ? 1 : tmp;
    }

    public String toString() {
        return "RegretWinnow: voted=" + this.voted + ", regret=" + this.mode;
    }

    public class MyClassifier
    implements Classifier,
    Serializable,
    Visible {
        private static final long serialVersionUID = 20080130L;
        private Hyperplane lpos_h;
        private double mytheta;

        public MyClassifier(Hyperplane pos_h, double mytheta) {
            this.lpos_h = pos_h;
            this.mytheta = mytheta;
        }

        public ClassLabel classification(Instance instance1) {
            Example a1 = new Example(instance1, new ClassLabel("POS"));
            Example aa = this.filterFeat(a1);
            Example example1 = Winnow.normalizeWeights(aa, true);
            Instance instance = example1.asInstance();
            double dec = this.lpos_h.score(instance) - this.mytheta;
            return dec >= 0.0 ? ClassLabel.positiveLabel(dec) : ClassLabel.negativeLabel(dec);
        }

        public Example filterFeat(Example ex) {
            MutableInstance ins = new MutableInstance();
            Iterator<Feature> i = ex.asInstance().featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                if (!this.lpos_h.hasFeature(f)) continue;
                ins.addNumeric(f, ex.getWeight(f));
            }
            return new Example(ins, ex.getLabel());
        }

        public String toString() {
            return "POS = " + this.lpos_h.toString();
        }

        public String explain(Instance instance) {
            return "BalancedWinnow: Not implemented yet";
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("BalancedWinnow Explanation");
            Explanation ex = new Explanation(top);
            return ex;
        }

        public Viewer toGUI() {
            TransformedViewer v = new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080130L;

                public Object transform(Object o) {
                    MyClassifier mycl = (MyClassifier)o;
                    return mycl.lpos_h;
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

