/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.random;

import edu.cmu.minorthird.classify.algorithms.random.Gamma;
import edu.cmu.minorthird.classify.algorithms.random.Poisson;

public class NegativeBinomial {
    protected int n;
    protected double p;
    protected Gamma gamma;
    protected Poisson poisson;

    public NegativeBinomial(int n, double p) {
        this.setNandP(n, p);
        this.gamma = new Gamma(n, 1.0);
        this.poisson = new Poisson(0.0);
    }

    public int nextInt() {
        return this.nextInt(this.n, this.p);
    }

    public int nextInt(int n, double p) {
        double x = p / (1.0 - p);
        double y = x * this.gamma.nextDouble(n, 1.0);
        return this.poisson.nextInt(y);
    }

    public void setNandP(int n, double p) {
        this.n = n;
        this.p = p;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.n + "," + this.p + ")";
    }
}

