/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.svm;

import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.algorithms.svm.SVMClassifier;
import edu.cmu.minorthird.classify.algorithms.svm.SVMUtils;
import java.io.IOException;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_parameter;
import libsvm.svm_problem;
import org.apache.log4j.Logger;

public class SVMLearner
extends BatchClassifierLearner {
    static Logger logger = Logger.getLogger(SVMLearner.class);
    private svm_parameter parameters;
    private ExampleSchema schema;
    public static String parameterSVMTypeHelp = "Set the SVM type to use.";
    public static String kernelTypeHelp = "Set the type of kernel function.";
    public static String degreeHelp = "Set the degree in kernel function.";
    public static String gammaHelp = "Set the gamma in kernel function.";
    public static String coef0Help = "Set the coef0 in kernel function.";
    public static String nuHelp = "Set the parameter nu. (For nu-SVC, one-class SVM, and nu-SVR only)";
    public static String cacheSizeHelp = "Set the cache memory size in MB.";
    public static String cParameterHelp = "Set the parameter C. (For C-SVC, epsilon-SVR, and nu-SVR only)";
    public static String stoppingCriteriaHelp = "Set the tolerance of termination criterion.";
    public static String lossFunctionEpsilonHelp = "Set the epsilon in the loss function of epsilon-SVR.";
    public static String useShrinkingHeuristicsHelp = "Whether or not to use shrinking heuristics.";
    public static String cParameterWeightHelp = "Set the parameter C of class i to weight*C for C-SVC.";
    public static String doProbabilityEstimatesHelp = "Whether to train for probability estimates. (For SVC and SVR models only).";

    public SVMLearner(svm_parameter parameters) {
        this.parameters = parameters;
    }

    public SVMLearner() {
        this(SVMLearner.getDefaultParameters());
    }

    protected static svm_parameter getDefaultParameters() {
        svm_parameter p = new svm_parameter();
        p.svm_type = 0;
        p.kernel_type = 0;
        p.degree = 3;
        p.gamma = 0.0;
        p.coef0 = 0.0;
        p.nu = 0.5;
        p.cache_size = 40.0;
        p.C = 1.0;
        p.eps = 0.001;
        p.p = 0.1;
        p.shrinking = 1;
        p.nr_weight = 0;
        p.weight_label = new int[0];
        p.weight = new double[0];
        p.probability = 0;
        return p;
    }

    public void setSchema(ExampleSchema schema) {
        this.schema = schema;
    }

    public ExampleSchema getSchema() {
        return this.schema;
    }

    public Classifier batchTrain(Dataset dataset) {
        svm_problem problem = SVMUtils.convertToSVMProblem(dataset);
        svm_model model = svm.svm_train(problem, this.parameters);
        if (logger.isDebugEnabled()) {
            try {
                svm.svm_save_model("./modelTest.mdl", model);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return new SVMClassifier(model, dataset.getSchema(), dataset.getFeatureFactory());
    }

    public void setParameterSVMType(int type) {
        this.parameters.svm_type = type;
    }

    public int getParameterSVMType() {
        return this.parameters.svm_type;
    }

    public String getParameterSVMTypeHelp() {
        return parameterSVMTypeHelp;
    }

    public void setKernelType(int type) {
        this.parameters.kernel_type = type;
    }

    public int getKernelType() {
        return this.parameters.kernel_type;
    }

    public String getKernelTypeHelp() {
        return kernelTypeHelp;
    }

    public void setDegree(int deg) {
        this.parameters.degree = deg;
    }

    public int getDegree() {
        return this.parameters.degree;
    }

    public String getDegreeHelp() {
        return degreeHelp;
    }

    public void setGamma(double g) {
        this.parameters.gamma = g;
    }

    public double getGamma() {
        return this.parameters.gamma;
    }

    public String getGammaHelp() {
        return gammaHelp;
    }

    public void setCoef0(double c) {
        this.parameters.coef0 = c;
    }

    public double getCoef0() {
        return this.parameters.coef0;
    }

    public String getCoef0Help() {
        return coef0Help;
    }

    public void setNu(double n) {
        this.parameters.nu = n;
    }

    public double getNu() {
        return this.parameters.nu;
    }

    public String getNuHelp() {
        return nuHelp;
    }

    public void setCacheSize(double s) {
        this.parameters.cache_size = s;
    }

    public double getCacheSize() {
        return this.parameters.cache_size;
    }

    public String getCacheSizeHelp() {
        return cacheSizeHelp;
    }

    public void setCParameter(double c) {
        this.parameters.C = c;
    }

    public double getCParameter() {
        return this.parameters.C;
    }

    public String getCParameterHelp() {
        return cParameterHelp;
    }

    public void setStoppingCriteria(double c) {
        this.parameters.eps = c;
    }

    public double getStoppingCriteria() {
        return this.parameters.eps;
    }

    public String getStoppingCriteriaHelp() {
        return stoppingCriteriaHelp;
    }

    public void setLossFunctionEpsilon(double l) {
        this.parameters.p = l;
    }

    public double getLossFunctionEpsilon() {
        return this.parameters.p;
    }

    public String getLossFunctionEpsilonHelp() {
        return lossFunctionEpsilonHelp;
    }

    public void setUseShrinkingHeuristics(boolean flag) {
        this.parameters.shrinking = flag ? 1 : 0;
    }

    public boolean getUseShrinkingHeuristics() {
        return this.parameters.shrinking > 0;
    }

    public String getUseShrinkingHeuristicsHelp() {
        return useShrinkingHeuristicsHelp;
    }

    public void setCParameterWeight(int w) {
        this.parameters.nr_weight = w;
    }

    public int getCParameterWeight() {
        return this.parameters.nr_weight;
    }

    public String getCParameterWeightHelp() {
        return cParameterWeightHelp;
    }

    public void setDoProbabilityEstimates(boolean flag) {
        this.parameters.probability = flag ? 1 : 0;
    }

    public boolean getDoProbabilityEstimates() {
        return this.parameters.probability > 0;
    }

    public String getDoProbabilityEstimatesHelp() {
        return doProbabilityEstimatesHelp;
    }

    public void setParameterKernelType(int type) {
        this.parameters.kernel_type = type;
    }

    public void setParameterGamma(double gamma) {
        this.parameters.gamma = gamma;
    }

    public void setParameterC(double c) {
        this.parameters.C = c;
    }
}

