/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.IndexedViewer;
import edu.cmu.minorthird.util.gui.LineCharter;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationGroup
implements Visible,
Serializable,
Saveable {
    static final long serialVersionUID = 20080130L;
    private final SortedMap<String, Evaluation> members = new TreeMap<String, Evaluation>();
    private Evaluation someEvaluation = null;
    private SummaryViewer sv;
    private static final String FORMAT_NAME = "Evaluation Group";

    public void add(String name, Evaluation evaluation) {
        if (this.someEvaluation == null) {
            this.someEvaluation = evaluation;
        }
        this.members.put(name, evaluation);
    }

    public Iterator<String> evalNameIterator() {
        return this.members.keySet().iterator();
    }

    public Evaluation getEvaluation(String name) {
        return (Evaluation)this.members.get(name);
    }

    public String toString() {
        return this.members.toString();
    }

    @Override
    public Viewer toGUI() {
        if (this.members.keySet().size() == 0) {
            return new VanillaViewer("empty EvaluationGroup");
        }
        ParallelViewer main = new ParallelViewer();
        this.sv = new SummaryViewer();
        main.addSubView("Summary", new ZoomedViewer(this.sv, new Evaluation.PropertyViewer()));
        IndexedViewer indexViewer = new IndexedViewer(){
            static final long serialVersionUID = 20080130L;

            public Object[] indexFor(Object o) {
                EvaluationGroup group = (EvaluationGroup)o;
                return group.members.keySet().toArray();
            }
        };
        TransformedViewer evaluationKeyViewer = new TransformedViewer(){
            static final long serialVersionUID = 20080130L;

            public Object transform(Object o) {
                return EvaluationGroup.this.members.get(o);
            }
        };
        evaluationKeyViewer.setSubView(this.someEvaluation.toGUI());
        ZoomedViewer zooomer = new ZoomedViewer(indexViewer, evaluationKeyViewer);
        zooomer.setHorizontal();
        ComponentViewer prViewer = new ComponentViewer(){
            static final long serialVersionUID = 20080130L;

            public JComponent componentFor(Object o) {
                EvaluationGroup group = (EvaluationGroup)o;
                LineCharter lc = new LineCharter();
                for (String key : group.members.keySet()) {
                    Evaluation e = (Evaluation)group.members.get(key);
                    double[] p = e.elevenPointPrecision();
                    lc.startCurve(key);
                    for (int j = 0; j <= 10; ++j) {
                        lc.addPoint((double)j / 10.0, p[j]);
                    }
                }
                return lc.getPanel("11Pt Interpolated Precision vs Recall", "Recall", "Precision");
            }
        };
        ComponentViewer avgPRViewer = new ComponentViewer(){
            static final long serialVersionUID = 20080130L;

            public JComponent componentFor(Object o) {
                EvaluationGroup group = (EvaluationGroup)o;
                LineCharter lc = new LineCharter();
                double[] sum = new double[11];
                int n = 0;
                for (String key : group.members.keySet()) {
                    Evaluation e = (Evaluation)group.members.get(key);
                    double[] p = e.elevenPointPrecision();
                    for (int j = 0; j <= 10; ++j) {
                        int n2 = j;
                        sum[n2] = sum[n2] + p[j];
                    }
                    ++n;
                }
                lc.startCurve("Average of all " + n + " 11pt P-R Curves");
                for (int j = 0; j <= 10; ++j) {
                    lc.addPoint((double)j / 10.0, sum[j] / (double)n);
                }
                return lc.getPanel("Averaged 11Pt Interpolated Precision vs Recall", "Recall", "Precision");
            }
        };
        main.addSubView("11Pt Precision/Recall - Details", prViewer);
        main.addSubView("11Pt Precision/Recall - Average", avgPRViewer);
        main.addSubView("Details", zooomer);
        main.setContent(this);
        return main;
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".xls";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file));
            for (int i = 0; i < this.sv.columnHeads.length; ++i) {
                out.print(this.sv.columnHeads[i]);
                out.print("\t");
            }
            out.print("\n");
            int columns = this.sv.jtable.getColumnCount();
            int rows = this.sv.jtable.getRowCount();
            for (int x = 0; x < rows; ++x) {
                for (int y = 0; y < columns; ++y) {
                    out.print(this.sv.table[x][y].toString());
                    out.print("\t ");
                }
                out.print("\n");
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.out.println("Error Opening Excel File");
            e.printStackTrace();
        }
    }

    @Override
    public Object restore(File file) throws IOException {
        throw new UnsupportedOperationException("Cannot load EvaluationGroup object");
    }

    public static void main(String[] args) {
        try {
            EvaluationGroup group = new EvaluationGroup();
            for (int i = 0; i < args.length; ++i) {
                try {
                    Evaluation v = Evaluation.load(new File(args[i]));
                    group.add(args[i], v);
                    continue;
                }
                catch (IOException ex) {
                    try {
                        Evaluation v = (Evaluation)IOUtil.loadSerialized(new File(args[i]));
                        group.add(args[i], v);
                        continue;
                    }
                    catch (Exception ex2) {
                        System.out.println("usage: EvaluationGroup serializedFile1 serializedFile2 ...");
                        ex2.printStackTrace();
                    }
                }
            }
            new ViewerFrame("From file " + args[0], group.toGUI());
        }
        catch (Exception e) {
            System.out.println("usage: EvaluationGroup serializedFile1 serializedFile2 ...");
            e.printStackTrace();
        }
    }

    class SummaryViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;
        private EvaluationGroup group = null;
        public Object[][] table;
        public String[] columnHeads;
        public JTable jtable;

        SummaryViewer() {
        }

        public JComponent componentFor(Object o) {
            this.group = (EvaluationGroup)o;
            this.columnHeads = new String[this.group.members.keySet().size() + 1];
            this.columnHeads[0] = "Statistic";
            int k = 1;
            Iterator i = this.group.members.keySet().iterator();
            while (i.hasNext()) {
                this.columnHeads[k] = (String)i.next();
                ++k;
            }
            ExampleSchema schema = EvaluationGroup.this.someEvaluation.getSchema();
            int statNumber = 0;
            statNumber = EvaluationGroup.this.someEvaluation.isBinary() ? 10 + 2 * schema.getNumberOfClasses() : 3 + 2 * schema.getNumberOfClasses();
            this.table = new Object[statNumber][this.columnHeads.length];
            k = 1;
            Iterator i2 = this.group.members.keySet().iterator();
            while (i2.hasNext()) {
                Evaluation v = (Evaluation)this.group.members.get(i2.next());
                String[] statNames = v.summaryStatisticNames();
                double[] ss = v.summaryStatistics();
                for (int j = 0; j < ss.length; ++j) {
                    this.table[j][0] = statNames[j];
                    this.table[j][k] = new Double(ss[j]);
                }
                ++k;
            }
            this.jtable = new JTable(this.table, this.columnHeads);
            Viewer.Transform keyTransform = new Viewer.Transform(){

                public Object transform(Object key) {
                    return SummaryViewer.this.group.members.get(key);
                }
            };
            this.monitorSelections(this.jtable, 0, keyTransform);
            JScrollPane scroll = new JScrollPane(this.jtable);
            return scroll;
        }
    }
}

