/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.HasSubpopulationId;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaveOneOutSplitter<T>
implements Splitter<T> {
    private Random random;
    private Splitter<T> crossValSplitter;

    public LeaveOneOutSplitter(Random random2) {
        this.random = random2;
    }

    public LeaveOneOutSplitter() {
        this(new Random());
    }

    @Override
    public void split(Iterator<T> i) {
        ArrayList<T> buf = new ArrayList<T>();
        HashSet<String> subpops = new HashSet<String>();
        while (i.hasNext()) {
            T t = i.next();
            buf.add(t);
            String id = t instanceof HasSubpopulationId ? ((HasSubpopulationId)t).getSubpopulationId() : "youNeeekID#" + subpops.size();
            subpops.add(id);
        }
        this.crossValSplitter = new CrossValSplitter(this.random, subpops.size());
        this.crossValSplitter.split(buf.iterator());
    }

    @Override
    public int getNumPartitions() {
        return this.crossValSplitter.getNumPartitions();
    }

    @Override
    public Iterator<T> getTrain(int k) {
        return this.crossValSplitter.getTrain(k);
    }

    @Override
    public Iterator<T> getTest(int k) {
        return this.crossValSplitter.getTest(k);
    }

    public String toString() {
        return "[LeaveOneOutSplitter]";
    }
}

