/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.SubpopSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSplitter<T>
implements Splitter<T> {
    private Random random;
    private double trainFraction;
    private List<T> trainList = null;
    private List<T> testList = null;

    public RandomSplitter(Random random2, double trainFraction) {
        this.random = random2;
        this.trainFraction = trainFraction;
    }

    public RandomSplitter(double trainFraction) {
        this(new Random(), trainFraction);
    }

    public RandomSplitter() {
        this(0.7);
    }

    public void setTrainFraction(double f) {
        this.trainFraction = f;
    }

    public double getTrainFraction() {
        return this.trainFraction;
    }

    @Override
    public void split(Iterator<T> i) {
        this.trainList = new ArrayList<T>();
        this.testList = new ArrayList<T>();
        Iterator<List<T>> j = new SubpopSorter<T>(i).subpopIterator();
        while (j.hasNext()) {
            List<T> subpop = j.next();
            if (this.random.nextDouble() <= this.trainFraction) {
                this.trainList.addAll(subpop);
                continue;
            }
            this.testList.addAll(subpop);
        }
    }

    @Override
    public int getNumPartitions() {
        return 1;
    }

    @Override
    public Iterator<T> getTrain(int k) {
        return this.trainList.iterator();
    }

    @Override
    public Iterator<T> getTest(int k) {
        return this.testList.iterator();
    }

    public String toString() {
        return "[RandomSplit " + this.trainFraction + "]";
    }
}

