/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiExample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDatasetIndex
implements Serializable {
    static final long serialVersionUID = 20080131L;
    private SortedMap<Feature, List<MultiExample>> indexByFeature = new TreeMap<Feature, List<MultiExample>>();
    private SortedMap<String, List<MultiExample>> indexByClass = new TreeMap<String, List<MultiExample>>();
    private int sumFeatureValues = 0;
    private int exampleCount;

    public MultiDatasetIndex() {
    }

    public MultiDatasetIndex(MultiDataset data) {
        this();
        Iterator<MultiExample> i = data.multiIterator();
        while (i.hasNext()) {
            this.addMultiExample(i.next());
        }
    }

    public void addMultiExample(MultiExample e) {
        this.classIndex(e.getMultiLabel().bestClassName().toString()).add(e);
        Iterator<Feature> j = e.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            this.featureIndex(f).add(e);
            ++this.sumFeatureValues;
        }
        ++this.exampleCount;
    }

    public Iterator<Feature> featureIterator() {
        return this.indexByFeature.keySet().iterator();
    }

    public int size(Feature f) {
        return this.featureIndex(f).size();
    }

    public int size(String label) {
        return this.classIndex(label).size();
    }

    public MultiExample getMultiExample(Feature f, int i) {
        return this.featureIndex(f).get(i);
    }

    public MultiExample getMultiExample(String label, int i) {
        return this.classIndex(label).get(i);
    }

    public Iterator<MultiExample> getNeighbors(Instance instance) {
        HashSet<MultiExample> set = new HashSet<MultiExample>();
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature feature = i.next();
            for (MultiExample e : this.featureIndex(feature)) {
                set.add(e);
            }
        }
        return set.iterator();
    }

    public int numberOfFeatures() {
        return this.indexByFeature.keySet().size();
    }

    public double averageFeaturesPerExample() {
        return (double)this.sumFeatureValues / (double)this.exampleCount;
    }

    protected List<MultiExample> featureIndex(Feature feature) {
        ArrayList result = (ArrayList)this.indexByFeature.get(feature);
        if (result == null) {
            result = new ArrayList();
            this.indexByFeature.put(feature, result);
        }
        return result;
    }

    protected List<MultiExample> classIndex(String label) {
        ArrayList result = (ArrayList)this.indexByClass.get(label);
        if (result == null) {
            result = new ArrayList();
            this.indexByClass.put(label, result);
        }
        return result;
    }

    public String toString() {
        int j;
        StringBuffer buf = new StringBuffer("[index");
        Iterator<Object> i = this.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            buf.append("\n" + f + ":");
            for (j = 0; j < this.size(f); ++j) {
                buf.append("\n\t" + this.getMultiExample(f, j).toString());
            }
        }
        for (String label : this.indexByClass.keySet()) {
            buf.append("\n" + label + ":");
            for (j = 0; j < this.size(label); ++j) {
                buf.append("\n\t" + this.getMultiExample(label, j).toString());
            }
        }
        buf.append("\nindex]");
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println("MultiDatasetIndex");
    }
}

