/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.ranking;

import edu.cmu.minorthird.classify.BatchBinaryClassifierLearner;
import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchRankingLearner
extends BatchBinaryClassifierLearner {
    public static Map<String, List<Example>> splitIntoRankings(Dataset data) {
        HashMap<String, List<Example>> map = new HashMap<String, List<Example>>();
        Iterator<Example> i = data.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            ArrayList<Example> list = (ArrayList<Example>)map.get(ex.getSubpopulationId());
            if (list == null) {
                list = new ArrayList<Example>();
                map.put(ex.getSubpopulationId(), list);
            }
            list.add(ex);
        }
        return map;
    }

    public static Map<String, List<Example>> listsWithOneExampleEach(Map<String, List<Example>> rankingLists) {
        HashMap<String, List<Example>> map1 = new HashMap<String, List<Example>>();
        for (String key : rankingLists.keySet()) {
            Example exi;
            int j;
            ArrayList<Example> posExamples = new ArrayList<Example>();
            ArrayList<Example> negExamples = new ArrayList<Example>();
            List<Example> ranking = rankingLists.get(key);
            for (j = 0; j < ranking.size(); ++j) {
                exi = ranking.get(j);
                if (exi.getLabel().isPositive()) {
                    posExamples.add(exi);
                    continue;
                }
                negExamples.add(exi);
            }
            for (j = 0; j < posExamples.size(); ++j) {
                exi = (Example)posExamples.get(j);
                ArrayList<Example> ranking1 = new ArrayList<Example>();
                ranking1.addAll(negExamples);
                ranking1.add(exi);
                map1.put(key + "." + j, ranking1);
            }
        }
        return map1;
    }

    public static void sortByScore(final BinaryClassifier c, List<Example> data) {
        Collections.sort(data, new Comparator<Example>(){

            @Override
            public int compare(Example instA, Example instB) {
                int cmp;
                double diff = c.score(instB) - c.score(instA);
                int n = diff > 0.0 ? 1 : (cmp = diff < 0.0 ? -1 : 0);
                if (cmp != 0) {
                    return cmp;
                }
                if (instA instanceof Example && instB instanceof Example) {
                    Example exA = instA;
                    Example exB = instB;
                    return (int)(exA.getLabel().numericLabel() - exB.getLabel().numericLabel());
                }
                return 0;
            }
        });
    }
}

