/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.OneVsAllClassifier;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import javax.swing.JComponent;

public class SequenceUtils {
    public static OnlineClassifierLearner[] duplicatePrototypeLearner(OnlineClassifierLearner prototype, int n) {
        try {
            OnlineClassifierLearner[] result = new OnlineClassifierLearner[n];
            for (int i = 0; i < n; ++i) {
                result[i] = (OnlineClassifierLearner)prototype.copy();
                result[i].reset();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("innerLearner must be cloneable");
        }
    }

    public static class MultiClassClassifier
    extends OneVsAllClassifier
    implements Serializable {
        private static final long serialVersionUID = 20080207L;

        public MultiClassClassifier(ExampleSchema schema, ClassifierLearner[] learners) {
            super(schema.validClassNames(), MultiClassClassifier.getBinaryClassifiers(learners));
        }

        public MultiClassClassifier(ExampleSchema schema, Classifier[] classifiers) {
            super(schema.validClassNames(), classifiers);
        }

        public ExampleSchema getSchema() {
            return new ExampleSchema(this.getClassNames());
        }

        public static BinaryClassifier[] getBinaryClassifiers(ClassifierLearner[] learners) {
            BinaryClassifier[] result = new BinaryClassifier[learners.length];
            for (int i = 0; i < learners.length; ++i) {
                result[i] = new MyBinaryClassifier(learners[i].getClassifier());
            }
            return result;
        }

        private static class MyBinaryClassifier
        extends BinaryClassifier
        implements Visible {
            static final long serialVersionUID = 20080207L;
            private Classifier c;

            public MyBinaryClassifier(Classifier c) {
                this.c = c;
            }

            public double score(Instance instance) {
                return this.c.classification(instance).posWeight();
            }

            public String explain(Instance instance) {
                return this.c.explain(instance);
            }

            public Explanation getExplanation(Instance instance) {
                Explanation.Node top = this.c.getExplanation(instance).getTopNode();
                Explanation ex = new Explanation(top);
                return ex;
            }

            public Viewer toGUI() {
                ComponentViewer v = new ComponentViewer(){
                    static final long serialVersionUID = 20080207L;

                    public JComponent componentFor(Object o) {
                        MyBinaryClassifier b = (MyBinaryClassifier)o;
                        return b.c instanceof Visible ? ((Visible)((Object)b.c)).toGUI() : new VanillaViewer(MyBinaryClassifier.this.c);
                    }
                };
                v.setContent(this);
                return v;
            }

            public String toString() {
                return "[MyBC " + this.c + "]";
            }
        }
    }
}

